/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.ApiStatus;

public class ParticleUtil {
    @ApiStatus.Internal
    public static Supplier<ShaderInstance> particleShader = GameRenderer::getParticleShader;
    public static final ParticleRenderType ADDITIVE_TRANSLUCENCY_RENDER_TYPE = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
            RenderSystem.activeTexture((int)33986);
            RenderSystem.activeTexture((int)33984);
            RenderSystem.setShader(particleShader);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "PARTICLE_SHEET_ADDITIVE_TRANSLUCENT";
        }
    };

    public static void spawnParticleInASphere(Level level, double x, double y, double z, Supplier<ParticleOptions> type, int amount, float speed, float angleVariation, float speedVariation) {
        double azimuthIncrement = Math.PI * (3.0 - Math.sqrt(5.0));
        for (int i = 0; i < amount; ++i) {
            double inclination = Math.acos(1.0 - 2.0 * ((double)i + 0.5) / (double)amount);
            double azimuth = azimuthIncrement * (double)i;
            if (angleVariation != 0.0f) {
                inclination += (double)(level.random.nextFloat() * angleVariation - angleVariation / 2.0f);
                azimuth += (double)(level.random.nextFloat() * angleVariation - angleVariation / 2.0f);
            }
            float s = speed;
            if (speedVariation != 0.0f) {
                s += level.random.nextFloat() * speedVariation - speedVariation / 2.0f;
            }
            double vx = (double)s * Math.sin(inclination) * Math.cos(azimuth);
            double vy = (double)s * Math.sin(inclination) * Math.sin(azimuth);
            double vz = (double)s * Math.cos(inclination);
            level.addParticle(type.get(), x, y, z, vx, vy, vz);
        }
    }

    public static void spawnParticleOnBlockShape(Level level, BlockPos pos, ParticleOptions particleOptions, UniformInt uniformInt, float maxSpeed) {
        ParticleUtil.spawnParticleOnBoundingBox(level.getBlockState(pos).getShape((BlockGetter)level, pos).bounds().move(pos), level, particleOptions, uniformInt, maxSpeed);
    }

    public static void spawnParticleOnBoundingBox(AABB bb, Level level, ParticleOptions particleOptions, UniformInt uniformInt, float maxSpeed) {
        double z;
        double z2;
        double dz;
        double dy;
        double dx;
        double y;
        double x;
        int j;
        RandomSource random = level.random;
        float offset = 0.1f;
        Vec3 blockCenter = new Vec3(bb.minX - 0.5 + (bb.maxX - bb.minX) / 2.0, bb.minY - 0.5 + (bb.maxY - bb.minY) / 2.0, bb.minZ - 0.5 + (bb.maxZ - bb.minZ) / 2.0);
        bb = bb.move(-blockCenter.x, -blockCenter.y, -blockCenter.z);
        int i = uniformInt.sample(random);
        for (j = 0; j < i; ++j) {
            x = random.nextDouble();
            y = random.nextDouble();
            if (!(x > bb.minX) || !(x < bb.maxX) || !(y > bb.minY) || !(y < bb.maxY)) continue;
            dx = (double)maxSpeed * level.random.nextDouble();
            dy = (double)maxSpeed * level.random.nextDouble();
            dz = 0.0;
            level.addParticle(particleOptions, blockCenter.x + x, blockCenter.y + y, blockCenter.z + bb.minZ - (double)offset, dx, dy, dz);
        }
        i = uniformInt.sample(random);
        for (j = 0; j < i; ++j) {
            x = random.nextDouble();
            y = random.nextDouble();
            if (!(x > bb.minX) || !(x < bb.maxX) || !(y > bb.minY) || !(y < bb.maxY)) continue;
            dx = (double)maxSpeed * level.random.nextDouble();
            dy = (double)maxSpeed * level.random.nextDouble();
            dz = 0.0;
            level.addParticle(particleOptions, blockCenter.x() + x, blockCenter.y() + y, blockCenter.z() + bb.maxZ + (double)offset, dx, dy, dz);
        }
        i = uniformInt.sample(random);
        for (j = 0; j < i; ++j) {
            z2 = random.nextDouble();
            y = random.nextDouble();
            if (!(z2 > bb.minZ) || !(z2 < bb.maxZ) || !(y > bb.minY) || !(y < bb.maxY)) continue;
            dx = 0.0;
            dy = (double)maxSpeed * level.random.nextDouble();
            dz = (double)maxSpeed * level.random.nextDouble();
            level.addParticle(particleOptions, blockCenter.x() + bb.minX - (double)offset, blockCenter.y() + y, blockCenter.z() + z2, dx, dy, dz);
        }
        i = uniformInt.sample(random);
        for (j = 0; j < i; ++j) {
            z2 = random.nextDouble();
            y = random.nextDouble();
            if (!(z2 > bb.minZ) || !(z2 < bb.maxZ) || !(y > bb.minY) || !(y < bb.maxY)) continue;
            dx = 0.0;
            dy = (double)maxSpeed * level.random.nextDouble();
            dz = (double)maxSpeed * level.random.nextDouble();
            level.addParticle(particleOptions, blockCenter.x() + bb.maxX + (double)offset, blockCenter.y() + y, blockCenter.z() + z2, dx, dy, dz);
        }
        i = uniformInt.sample(random);
        for (j = 0; j < i; ++j) {
            x = random.nextDouble();
            z = random.nextDouble();
            if (!(x > bb.minX) || !(x < bb.maxX) || !(z > bb.minZ) || !(z < bb.maxZ)) continue;
            dx = (double)maxSpeed * level.random.nextDouble();
            dy = 0.0;
            dz = (double)maxSpeed * level.random.nextDouble();
            level.addParticle(particleOptions, blockCenter.x() + x, blockCenter.y() + bb.minY - (double)offset, blockCenter.z() + z, dx, dy, dz);
        }
        i = uniformInt.sample(random);
        for (j = 0; j < i; ++j) {
            x = random.nextDouble();
            z = random.nextDouble();
            if (!(x > bb.minX) || !(x < bb.maxX) || !(z > bb.minZ) || !(z < bb.maxZ)) continue;
            dx = (double)maxSpeed * level.random.nextDouble();
            dy = 0.0;
            dz = (double)maxSpeed * level.random.nextDouble();
            level.addParticle(particleOptions, blockCenter.x() + x, blockCenter.y() + bb.maxY + (double)offset, blockCenter.z() + z, dx, dy, dz);
        }
    }

    public static void spawnParticlesOnBlockFaces(Level level, BlockPos pos, ParticleOptions particleOptions, UniformInt uniformInt, float minSpeed, float maxSpeed, boolean perpendicular) {
        for (Direction direction : Direction.values()) {
            int i = uniformInt.sample(level.random);
            for (int j = 0; j < i; ++j) {
                ParticleUtil.spawnParticleOnFace(level, pos, direction, particleOptions, minSpeed, maxSpeed, perpendicular);
            }
        }
    }

    public static void spawnParticleOnFace(Level level, BlockPos pos, Direction direction, ParticleOptions particleOptions, float minSpeed, float maxSpeed, boolean perpendicular) {
        double dz;
        double dy;
        double dx;
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        int i = direction.getStepX();
        int j = direction.getStepY();
        int k = direction.getStepZ();
        double d0 = vec3.x + (i == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5) : (double)i * 0.6);
        double d1 = vec3.y + (j == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5) : (double)j * 0.6);
        double d2 = vec3.z + (k == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5) : (double)k * 0.6);
        if (perpendicular) {
            dx = (float)i * Mth.randomBetween((RandomSource)level.random, (float)minSpeed, (float)maxSpeed);
            dy = (float)j * Mth.randomBetween((RandomSource)level.random, (float)minSpeed, (float)maxSpeed);
            dz = (float)k * Mth.randomBetween((RandomSource)level.random, (float)minSpeed, (float)maxSpeed);
        } else {
            float d = maxSpeed - minSpeed;
            dx = i == 0 ? (double)minSpeed + (double)d * level.random.nextDouble() : 0.0;
            dy = j == 0 ? (double)minSpeed + (double)d * level.random.nextDouble() : 0.0;
            dz = k == 0 ? (double)minSpeed + (double)d * level.random.nextDouble() : 0.0;
        }
        level.addParticle(particleOptions, d0, d1, d2, dx, dy, dz);
    }

    public static void spawnBreakParticles(VoxelShape shape, BlockPos pPos, BlockState pState, Level level) {
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        shape.forAllBoxes((x0, y0, z0, x1, y1, z1) -> {
            double d1 = Math.min(1.0, x1 - x0);
            double d2 = Math.min(1.0, y1 - y0);
            double d3 = Math.min(1.0, z1 - z0);
            int i = Math.max(2, Mth.ceil((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.ceil((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.ceil((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + x0;
                        double d8 = d5 * d2 + y0;
                        double d9 = d6 * d3 + z0;
                        particleEngine.add((Particle)new TerrainParticle((ClientLevel)level, (double)pPos.getX() + d7, (double)pPos.getY() + d8, (double)pPos.getZ() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, pState, pPos));
                    }
                }
            }
        });
    }
}

