/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import java.util.UUID;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ItemDisplayTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
IOwnerProtected {
    @Nullable
    private UUID owner = null;
    private NonNullList<ItemStack> stacks;

    protected ItemDisplayTile(BlockEntityType type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1);
    }

    protected ItemDisplayTile(BlockEntityType type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state);
        this.stacks = NonNullList.withSize((int)slots, (Object)ItemStack.EMPTY);
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setChanged() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.updateTileOnInventoryChanged();
        if (this.needsToUpdateClientWhenChanged()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
        super.setChanged();
    }

    public void updateTileOnInventoryChanged() {
    }

    public boolean needsToUpdateClientWhenChanged() {
        return true;
    }

    public void updateClientVisualsOnLoad() {
    }

    public ItemStack getDisplayedItem() {
        return this.getItem(0);
    }

    public void setDisplayedItem(ItemStack stack) {
        this.setItem(0, stack);
    }

    public ItemInteractionResult interactWithPlayerItem(Player player, InteractionHand handIn, ItemStack stack) {
        return this.interactWithPlayerItem(player, handIn, stack, 0);
    }

    public ItemInteractionResult interactWithPlayerItem(Player player, InteractionHand handIn, ItemStack handItem, int slot) {
        if (!this.isAccessibleBy(player)) {
            player.displayClientMessage((Component)Component.translatable((String)"container.isLocked", (Object[])new Object[]{""}), true);
        } else if (handIn == InteractionHand.MAIN_HAND) {
            if (handItem.isEmpty()) {
                ItemStack it = this.removeItemNoUpdate(slot);
                if (!it.isEmpty()) {
                    this.onItemRemoved(player, it, slot);
                    if (!this.level.isClientSide()) {
                        player.setItemInHand(handIn, it);
                        this.setChanged();
                    } else {
                        this.updateClientVisualsOnLoad();
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
                }
            } else if (this.canPlaceItem(slot, handItem)) {
                ItemStack it = handItem.copy();
                it.setCount(1);
                this.setItem(slot, it);
                handItem.consume(1, (LivingEntity)player);
                this.onItemAdded(player, it, slot);
                if (!this.level.isClientSide()) {
                    this.level.playSound(null, this.worldPosition, this.getAddItemSound(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.95f);
                } else {
                    this.updateClientVisualsOnLoad();
                }
                return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onItemRemoved(Player player, ItemStack stack, int slot) {
        this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.worldPosition, GameEvent.Context.of((Entity)player, (BlockState)this.getBlockState()));
    }

    public void onItemAdded(Player player, ItemStack stack, int slot) {
        this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.worldPosition, GameEvent.Context.of((Entity)player, (BlockState)this.getBlockState()));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, this.worldPosition, stack);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        }
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.ITEM_FRAME_ADD_ITEM;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!this.tryLoadLootTable(tag)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)registries);
        if (this.level != null) {
            if (this.level.isClientSide) {
                this.updateClientVisualsOnLoad();
            } else {
                this.updateTileOnInventoryChanged();
            }
        }
        this.loadOwner(tag);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)registries);
        }
        this.saveOwner(compound);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public AbstractContainerMenu createMenu(int id, Inventory player) {
        return ChestMenu.threeRows((int)id, (Inventory)player, (Container)this);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return null;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.isEmpty();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }
}

