/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.util;

import com.magistuarmory.EpicKnights;
import com.magistuarmory.config.MobEquipmentConfig;
import com.magistuarmory.util.DualKey;
import com.magistuarmory.util.MobEquipmentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;

public class MobEquipment {
    public static final MobEquipmentConfig MOBS_EQUIPMENT_CONFIG = EpicKnights.CONFIG.mobEquipments;
    static Map<DualKey<EntityType<? extends LivingEntity>, ResourceKey<Level>>, List<MobEquipment>> EQUIPMENTS = new HashMap<DualKey<EntityType<? extends LivingEntity>, ResourceKey<Level>>, List<MobEquipment>>();
    public List<EntityType<? extends LivingEntity>> entities = new ArrayList<EntityType<? extends LivingEntity>>();
    public List<ResourceKey<Level>> dimensions;
    public List<ArmorItem> helmets = new ArrayList<ArmorItem>();
    public List<ArmorItem> chestplates = new ArrayList<ArmorItem>();
    public List<ArmorItem> leggings = new ArrayList<ArmorItem>();
    public List<ArmorItem> boots = new ArrayList<ArmorItem>();
    public List<Item> weapons = new ArrayList<Item>();
    public List<ShieldItem> shields = new ArrayList<ShieldItem>();
    public double chance;

    MobEquipment(MinecraftServer server, String[] ids) {
        ArrayList<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
        this.chance = EpicKnights.GENERAL_CONFIG.equipChance;
        for (String id : ids) {
            Optional itemoptional;
            ResourceLocation resloc = ResourceLocation.parse((String)id);
            Optional entityoptional = BuiltInRegistries.ENTITY_TYPE.getOptional(resloc);
            if (entityoptional.isPresent()) {
                try {
                    this.entities.add((EntityType<? extends LivingEntity>)((EntityType)entityoptional.get()));
                    continue;
                }
                catch (ClassCastException e) {
                    System.out.println("[Epic-Knights Mob Equipment] Non-living entity type \"" + id + "\" is not allowed");
                }
            }
            if ((itemoptional = BuiltInRegistries.ITEM.getOptional(resloc)).isPresent()) {
                Object t = itemoptional.get();
                if (t instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)t;
                    switch (armor.getType().getSlot()) {
                        case HEAD: {
                            this.helmets.add(armor);
                            break;
                        }
                        case CHEST: {
                            this.chestplates.add(armor);
                            break;
                        }
                        case LEGS: {
                            this.leggings.add(armor);
                            break;
                        }
                        case FEET: {
                            this.boots.add(armor);
                        }
                    }
                    continue;
                }
                t = itemoptional.get();
                if (t instanceof ShieldItem) {
                    ShieldItem shield = (ShieldItem)t;
                    this.shields.add(shield);
                    continue;
                }
                this.weapons.add((Item)itemoptional.get());
                continue;
            }
            ResourceKey resourcekey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)resloc);
            ServerLevel serverlevel2 = server.getLevel(resourcekey);
            if (serverlevel2 != null) {
                dimensions.add((ResourceKey<Level>)serverlevel2.dimension());
                continue;
            }
            if (!id.matches("[-+]?[0-9]*\\.?[0-9]+")) continue;
            this.chance = Double.parseDouble(id);
        }
        if (dimensions.size() == 0) {
            server.getAllLevels().forEach(serverlevel -> dimensions.add(serverlevel.dimension()));
        }
        this.dimensions = dimensions;
    }

    public void equip(LivingEntity entity, RandomSource rand) {
        MobEquipmentHelper.setRandomItemSlot(entity, EquipmentSlot.HEAD, this.helmets, this.chance, rand);
        MobEquipmentHelper.setRandomItemSlot(entity, EquipmentSlot.CHEST, this.chestplates, this.chance, rand);
        MobEquipmentHelper.setRandomItemSlot(entity, EquipmentSlot.LEGS, this.leggings, this.chance, rand);
        MobEquipmentHelper.setRandomItemSlot(entity, EquipmentSlot.FEET, this.boots, this.chance, rand);
        MobEquipmentHelper.setRandomItemSlot(entity, EquipmentSlot.MAINHAND, this.weapons, this.chance, rand);
        MobEquipmentHelper.setRandomItemSlot(entity, EquipmentSlot.OFFHAND, this.shields, 0.5 * this.chance, rand);
    }

    public static void setup(MinecraftServer server) {
        for (String ids : MobEquipment.MOBS_EQUIPMENT_CONFIG.equipments) {
            MobEquipment equipment = new MobEquipment(server, ids.split(" "));
            equipment.entities.forEach(type -> equipment.dimensions.forEach(dimension -> {
                DualKey<EntityType, ResourceKey> key = new DualKey<EntityType, ResourceKey>((EntityType)type, (ResourceKey)dimension);
                EQUIPMENTS.putIfAbsent(key, new ArrayList());
                EQUIPMENTS.get(key).add(equipment);
            }));
        }
    }

    public static List<MobEquipment> get(LivingEntity entity) {
        return EQUIPMENTS.getOrDefault(new DualKey<EntityType, ResourceKey>(entity.getType(), entity.level().dimension()), new ArrayList());
    }
}

