/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.util;

import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.WeaponType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class CombatHelper {
    public static float getAttackReach(Player player, MedievalWeaponItem weapon) {
        return weapon.getAttackReach(CombatHelper.getBaseAttackReach(player));
    }

    public static float getBaseAttackReach(Player player) {
        return player.isCreative() ? 5.0f : 4.5f;
    }

    public static float getBaseAttackDamage(ModItemTier material, WeaponType type) {
        return type.getBaseAttackDamage() + 1.6f * material.getAttackDamageBonus() / type.getBaseAttackSpeed();
    }

    public static float getBaseAttackSpeed(ModItemTier material, WeaponType type) {
        return type.getAttackSpeed(material) - 4.0f;
    }

    public static float getDecreasedAttackDamage(ModItemTier material, WeaponType type) {
        return CombatHelper.getDecreasedAttackDamage(CombatHelper.getBaseAttackDamage(material, type), type);
    }

    public static float getDecreasedAttackSpeed(ModItemTier material, WeaponType type) {
        return CombatHelper.getDecreasedAttackSpeed(CombatHelper.getBaseAttackSpeed(material, type), type);
    }

    public static float getDecreasedAttackDamage(float baseattackdamage, WeaponType type) {
        return type.getTwoHanded() > 1 ? 14.0f * baseattackdamage / (3.0f * (float)type.getTwoHanded() + 12.0f) : baseattackdamage;
    }

    public static float getDecreasedAttackSpeed(float baseattackspeed, WeaponType type) {
        return 14.0f * (baseattackspeed + 4.0f) / (5.0f * (float)type.getTwoHanded() + 10.0f) - 4.0f;
    }

    public static float getSilverAttackDamage(ModItemTier material, WeaponType type) {
        return (float)Math.round(6.0f / type.getAttackSpeed(material) * 100.0f) / 100.0f;
    }

    public static float getArmorPiercingFactor(Entity attacker) {
        LivingEntity livingentity;
        Item item;
        float f = 1.0f;
        if (attacker instanceof LivingEntity && (item = (livingentity = (LivingEntity)attacker).getMainHandItem().getItem()) instanceof MedievalWeaponItem) {
            MedievalWeaponItem weapon = (MedievalWeaponItem)item;
            float f2 = (float)weapon.type.getArmorPiercing() / 100.0f;
            f = f2 / (1.0f - f2);
        }
        return f;
    }

    public static float getDamageAfterArmorAbsorb(DamageSource source, LivingEntity victim, float damage) {
        if (!source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            damage = CombatRules.getDamageAfterAbsorb((LivingEntity)victim, (float)damage, (DamageSource)source, (float)victim.getArmorValue(), (float)((float)victim.getAttributeValue(Attributes.ARMOR_TOUGHNESS)));
        }
        return damage;
    }

    public static float getDamageAfterMagicAbsorb(DamageSource source, LivingEntity victim, float damage) {
        float k;
        float j;
        float f;
        float f1;
        float f2;
        if (source.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return damage;
        }
        if (victim.hasEffect(MobEffects.DAMAGE_RESISTANCE) && !source.is(DamageTypeTags.BYPASSES_RESISTANCE) && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (j = 25.0f - (k = ((float)victim.getEffect(MobEffects.DAMAGE_RESISTANCE).getAmplifier() + 1.0f) * 5.0f))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (victim instanceof ServerPlayer) {
                ((ServerPlayer)victim).awardStat(Stats.CUSTOM.get((Object)Stats.DAMAGE_RESISTED), Math.round(f2 * 10.0f));
            } else if (source.getEntity() instanceof ServerPlayer) {
                ((ServerPlayer)source.getEntity()).awardStat(Stats.CUSTOM.get((Object)Stats.DAMAGE_DEALT_RESISTED), Math.round(f2 * 10.0f));
            }
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        if (source.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return damage;
        }
        k = EnchantmentHelper.getDamageProtection((ServerLevel)((ServerLevel)victim.level()), (LivingEntity)victim, (DamageSource)source);
        if (k > 0.0f) {
            damage = CombatRules.getDamageAfterMagicAbsorb((float)damage, (float)k);
        }
        return damage;
    }

    public static float getDamageAfterAbsorb(DamageSource source, LivingEntity victim, float damage) {
        Entity entity;
        if (victim.isInvulnerableTo(source) || damage <= 0.0f) {
            return 0.0f;
        }
        damage = CombatHelper.getDamageAfterArmorAbsorb(source, victim, damage);
        damage = CombatHelper.getDamageAfterMagicAbsorb(source, victim, damage);
        float f1 = Math.max(damage - victim.getAbsorptionAmount(), 0.0f);
        victim.setAbsorptionAmount(victim.getAbsorptionAmount() - (damage - f1));
        float f = damage - f1;
        if (f > 0.0f && f < 3.4028235E37f && (entity = source.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.awardStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round(f * 10.0f));
        }
        return f1;
    }
}

