/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.crafting;

import com.magistuarmory.item.ArmorDecoration;
import com.magistuarmory.item.crafting.neoforge.ArmorDecorationRecipeImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArmorDecorationRecipe
extends CustomRecipe {
    public static RecipeSerializer<ArmorDecorationRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(ArmorDecorationRecipe::new);

    public ArmorDecorationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, Level level) {
        ItemStack armorstack = ItemStack.EMPTY;
        ItemStack decorationstack = ItemStack.EMPTY;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ArmorDecoration) {
                if (!decorationstack.isEmpty()) {
                    return false;
                }
                decorationstack = stack;
                continue;
            }
            if (stack.getItem() instanceof ArmorItem) {
                if (!armorstack.isEmpty()) {
                    return false;
                }
                armorstack = stack;
                continue;
            }
            return false;
        }
        Item item = decorationstack.getItem();
        if (item instanceof ArmorDecoration) {
            ArmorDecoration decoration = (ArmorDecoration)item;
            return decoration.isApplicableForDecoration(armorstack);
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(CraftingInput container, @NotNull HolderLookup.Provider access) {
        Item item;
        ItemStack armorstack = ItemStack.EMPTY;
        ItemStack decorationstack = ItemStack.EMPTY;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ArmorDecoration) {
                decorationstack = stack;
                continue;
            }
            if (!(stack.getItem() instanceof ArmorItem)) continue;
            armorstack = stack.copy();
        }
        if (!armorstack.isEmpty() && !decorationstack.isEmpty() && (item = decorationstack.getItem()) instanceof ArmorDecoration) {
            ArmorDecoration decoration = (ArmorDecoration)item;
            decoration.decorate(armorstack, decorationstack);
        }
        return armorstack;
    }

    public boolean canCraftInDimensions(int n, int m) {
        return n * m >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ArmorDecorationRecipe.getSerializerInstance();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeSerializer<ArmorDecorationRecipe> getSerializerInstance() {
        return ArmorDecorationRecipeImpl.getSerializerInstance();
    }
}

