/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.armor;

import com.magistuarmory.api.client.render.model.ModModelsProvider;
import com.magistuarmory.item.ArmorDecoration;
import com.magistuarmory.item.ArmorDecorationItem;
import com.magistuarmory.item.armor.ArmorType;
import com.magistuarmory.item.armor.MedievalArmorItem;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class WearableArmorDecorationItem
extends MedievalArmorItem
implements ArmorDecoration {
    public WearableArmorDecorationItem(ArmorType material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.getArmorType().getLocation();
    }

    @Override
    public CompoundTag getCompoundTag(ItemStack stack) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.putString("name", this.getResourceLocation().toString());
        compoundnbt.putBoolean("dyeable", true);
        compoundnbt.putInt("color", 1);
        return compoundnbt;
    }

    @Override
    @NotNull
    public ArmorItem.Type getType() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableForDecoration(ItemStack stack) {
        if (stack.getItem() == this) return false;
        if (ArmorDecorationItem.getDecorationTags(stack).size() >= 8) return false;
        Item item = stack.getItem();
        if (!(item instanceof ArmorItem)) return false;
        ArmorItem armor = (ArmorItem)item;
        if (this.getType() != armor.getType()) return false;
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ModelLayerLocation createModelLocation() {
        return ModModelsProvider.createDecorationLocation(this.getResourceLocation());
    }
}

