/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.armor;

import com.magistuarmory.component.ModDataComponents;
import com.magistuarmory.item.ArmorDecorationItem;
import com.magistuarmory.item.DyeableArmorDecorationItem;
import com.magistuarmory.item.DyeableItemLike;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.ModItems;
import com.magistuarmory.item.armor.ArmorType;
import com.magistuarmory.item.armor.ISurcoat;
import com.magistuarmory.item.armor.MedievalArmorItem;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class KnightItem
extends MedievalArmorItem
implements ISurcoat,
DyeableItemLike,
IHasModelProperty {
    public KnightItem(ArmorType material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @Override
    public int getColor(ItemStack itemstack) {
        ArmorDecorationItem.DecorationInfo info = this.getPlumeDecorationInfo(itemstack);
        return FastColor.ARGB32.opaque((int)(info != null ? info.color() : 0));
    }

    public boolean hasPlume(ItemStack itemstack) {
        return this.getPlumeDecorationInfo(itemstack) != null;
    }

    public ArmorDecorationItem.DecorationInfo getPlumeDecorationInfo(ItemStack itemstack) {
        if (!itemstack.has((DataComponentType)ModDataComponents.ARMOR_DECORATION.get())) {
            return null;
        }
        String plumename = ((DyeableArmorDecorationItem)ModItems.BIG_PLUME_DECORATION.get()).getResourceLocation().toString();
        return ArmorDecorationItem.createDecorations(ArmorDecorationItem.getDecorationTags(itemstack)).stream().filter(d -> Objects.equals(d.name(), plumename)).findFirst().orElse(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)"has_plume"), (stack, level, entity, i) -> this.hasPlume(stack) ? 1.0f : 0.0f);
    }
}

