/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import dev.architectury.platform.Platform;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ModItemTier
implements Tier {
    private final String name;
    private final float attackDamageBonus;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;
    private final float speed;
    private final int uses;
    private final float density;
    public static ModItemTier WOOD = new ModItemTier("wood", (Tier)Tiers.WOOD, 0.0f);
    public static ModItemTier STONE = new ModItemTier("stone", (Tier)Tiers.STONE, 1.0f);
    public static ModItemTier IRON = new ModItemTier("iron", (Tier)Tiers.IRON, 2.0f);
    public static ModItemTier DIAMOND = new ModItemTier("diamond", (Tier)Tiers.DIAMOND, 3.0f);
    public static ModItemTier GOLD = new ModItemTier("gold", (Tier)Tiers.GOLD, 4.0f);
    public static ModItemTier NETHERITE = new ModItemTier("netherite", (Tier)Tiers.NETHERITE, 5.0f);
    public static ModItemTier COPPER = new ModItemTier("copper", (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 150, 0.7f, 0.0f, 10, Platform.isNeoForge() ? "neoforge:ingots/copper" : "c:copper_ingots", 1.0f);
    public static ModItemTier SILVER = new ModItemTier("silver", (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 230, 5.5f, 1.0f, 18, Platform.isNeoForge() ? "neoforge:ingots/silver" : "c:silver_ingots", 2.0f);
    public static ModItemTier STEEL = new ModItemTier("steel", (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 400, 6.0f, 2.5f, 14, Platform.isNeoForge() ? "neoforge:ingots/steel" : "c:steel_ingots", 2.0f);
    public static ModItemTier TIN = new ModItemTier("tin", (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 130, 6.0f, 0.0f, 20, Platform.isNeoForge() ? "neoforge:ingots/tin" : "c:tin_ingots", 2.0f);
    public static ModItemTier BRONZE = new ModItemTier("bronze", (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 200, 6.0f, 2.0f, 15, Platform.isNeoForge() ? "neoforge:ingots/bronze" : "c:bronze_ingots", 2.0f);
    private final TagKey<Block> incorrectBlocks;

    public ModItemTier(String name, Tier tier, float density) {
        this.name = name;
        this.incorrectBlocks = tier.getIncorrectBlocksForDrops();
        this.uses = tier.getUses();
        this.speed = tier.getSpeed();
        this.attackDamageBonus = tier.getAttackDamageBonus();
        this.enchantmentValue = tier.getEnchantmentValue();
        this.repairIngredient = () -> ((Tier)tier).getRepairIngredient();
        this.density = density;
    }

    public ModItemTier(String name, TagKey<Block> incorrectBlocks, int uses, float speed, float attack, int enchantment, String repairitemtag, float density) {
        this.name = name;
        this.incorrectBlocks = incorrectBlocks;
        this.uses = uses;
        this.speed = speed;
        this.attackDamageBonus = attack;
        this.enchantmentValue = enchantment;
        this.repairIngredient = () -> Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)repairitemtag)));
        this.density = density;
    }

    public float getAttackDamageBonus() {
        return this.attackDamageBonus;
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocks;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getUses() {
        return this.uses;
    }

    public String getMaterialName() {
        return this.name;
    }

    public float getDensity() {
        return this.density;
    }
}

