/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.EpicKnights;
import com.magistuarmory.client.HitResultHelper;
import com.magistuarmory.component.ModDataComponents;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.ModItems;
import com.magistuarmory.item.WeaponType;
import com.magistuarmory.network.PacketLanceCollision;
import com.magistuarmory.util.CombatHelper;
import com.magistuarmory.util.ModDamageSources;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LanceItem
extends MedievalWeaponItem {
    private final ModItemTier material;
    private List<ItemStack> dropItems = new ArrayList<ItemStack>();
    protected int clickedticks = 0;
    static int CLICKED_TICKS_COOLDOWN = 5;

    public LanceItem(Item.Properties properties, ModItemTier material, WeaponType type) {
        super(properties, material, type);
        this.material = material;
    }

    public void resetClickedTicks() {
        this.clickedticks = CLICKED_TICKS_COOLDOWN;
    }

    public float getClickedScale() {
        return Mth.clamp((float)((float)this.clickedticks / (float)CLICKED_TICKS_COOLDOWN), (float)0.0f, (float)1.0f);
    }

    public void setupDropItems() {
        String materialname;
        this.dropItems.add(new ItemStack((ItemLike)Items.STICK, 2));
        switch (materialname = this.material.getMaterialName()) {
            case "iron": {
                this.dropItems.add(new ItemStack((ItemLike)Items.IRON_INGOT));
                break;
            }
            case "gold": {
                this.dropItems.add(new ItemStack((ItemLike)Items.GOLD_INGOT));
                break;
            }
            case "diamond": {
                this.dropItems.add(new ItemStack((ItemLike)Items.DIAMOND));
                break;
            }
            case "netherite": {
                this.dropItems.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
                this.dropItems.add(new ItemStack((ItemLike)Items.DIAMOND));
                break;
            }
            case "steel": {
                this.dropItems.add(new ItemStack((ItemLike)ModItems.STEEL_INGOT.get()));
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        this.setRaised((LivingEntity)player, !this.isRaised((LivingEntity)player));
        return super.use(level, player, hand);
    }

    @Override
    public boolean onAttackClickEntity(ItemStack stack, Player player, Entity entity) {
        if (EpicKnights.GENERAL_CONFIG.disableLanceCollision) {
            return super.onAttackClickEntity(stack, player, entity);
        }
        if (player.isPassenger() && !this.isRaised((LivingEntity)player) && !player.getCooldowns().isOnCooldown((Item)this)) {
            this.resetClickedTicks();
        }
        player.swing(InteractionHand.MAIN_HAND);
        return false;
    }

    public void collide(Player player, LivingEntity victim, Level level) {
        if (player == null || level == null) {
            return;
        }
        if (!this.isRaised((LivingEntity)player) && !player.getCooldowns().isOnCooldown((Item)this) && player.isPassenger()) {
            float speed = this.getVelocityProjection((Entity)player);
            if (player.getRootVehicle() instanceof Horse && (double)speed >= ((Horse)player.getRootVehicle()).getAttribute(Attributes.MOVEMENT_SPEED).getValue() || !(player.getRootVehicle() instanceof Horse) && (double)speed >= 0.233) {
                PacketLanceCollision.sendToServer((Entity)player, (Entity)victim);
                player.resetAttackStrengthTicker();
            }
        }
    }

    @Override
    public boolean onHurtEntity(DamageSource source, LivingEntity victim, float damage) {
        Entity entity;
        if (EpicKnights.GENERAL_CONFIG.disableLanceCollision) {
            return super.onHurtEntity(source, victim, damage);
        }
        if (victim.level().isClientSide() || ModDamageSources.isAdditional(source) || !((entity = source.getEntity()) instanceof LivingEntity)) {
            return true;
        }
        LivingEntity attacker = (LivingEntity)entity;
        float speed = 0.0f;
        float bonusdamage = 0.0f;
        boolean dismount = false;
        if (attacker instanceof Mob) {
            Mob mob = (Mob)attacker;
            ItemStack stack = mob.getMainHandItem();
            speed = this.getRideSpeed(stack);
            this.setRideSpeed(stack, 0.0f);
            bonusdamage = this.calcBonusDamage((Entity)attacker, speed);
            dismount = this.getDismount(stack);
            this.setDismount(stack, false);
        } else if (attacker instanceof Player) {
            Player player = (Player)attacker;
            ItemStack stack = player.getMainHandItem();
            speed = this.getRideSpeed(stack);
            this.setRideSpeed(stack, 0.0f);
            bonusdamage = this.calcBonusDamage((Entity)attacker, speed);
            dismount = this.getDismount(stack);
            this.setDismount(stack, false);
            if (stack.getDamageValue() >= stack.getMaxDamage() - 1) {
                this.onBroken(player);
            } else if (!player.isCreative() && ((float)victim.getArmorValue() >= 9.0f * this.material.getAttackDamageBonus() || victim.isBlocking())) {
                stack.setDamageValue(stack.getDamageValue() + (int)((0.6 + (double)(bonusdamage / 20.0f)) * victim.level().getRandom().nextDouble() * (double)stack.getMaxDamage()));
            }
            for (ItemStack stack0 : player.getInventory().items) {
                this.setRaised((LivingEntity)player, true);
                player.getCooldowns().addCooldown(stack0.getItem(), (int)player.getCurrentItemAttackStrengthDelay());
            }
            if (stack.getDamageValue() >= stack.getMaxDamage()) {
                this.onBroken(player);
                stack.setCount(0);
            }
        }
        Vec3 vec = attacker.getViewVector(1.0f);
        double magnitude = Math.min(1.0f, speed * this.getTotalMass((Entity)attacker) / this.getTotalMass((Entity)victim));
        Vec3 vel = vec.multiply(magnitude, magnitude, magnitude);
        if (victim.isPassenger()) {
            victim.getRootVehicle().setDeltaMovement(victim.getRootVehicle().getDeltaMovement().add(vel));
            victim.getRootVehicle().hasImpulse = true;
            if (dismount) {
                victim.stopRiding();
            }
        } else {
            victim.setDeltaMovement(victim.getDeltaMovement().add(vel));
            victim.hasImpulse = true;
        }
        if (!super.onHurtEntity(source, victim, bonusdamage + damage) && bonusdamage != 0.0f) {
            victim.hurt(ModDamageSources.additional((Entity)attacker), bonusdamage + damage);
            return true;
        }
        return false;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean selected) {
        if (EpicKnights.GENERAL_CONFIG.disableLanceCollision) {
            super.inventoryTick(stack, level, entity, i, selected);
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level.isClientSide && player.getMainHandItem().getItem() instanceof LanceItem) {
                HitResult hit = HitResultHelper.getMouseOver(Minecraft.getInstance(), CombatHelper.getAttackReach(player, this));
                if (hit instanceof EntityHitResult) {
                    EntityHitResult entityhit = (EntityHitResult)hit;
                    Entity victim = entityhit.getEntity();
                    if (player.isPassenger() && victim instanceof LivingEntity && victim.isAlive() && victim.getId() != player.getVehicle().getId()) {
                        this.collide(player, (LivingEntity)victim, level);
                    }
                }
                if (this.clickedticks > 0) {
                    --this.clickedticks;
                }
            }
            if (!this.isRaised((LivingEntity)player) && player.getCooldowns().isOnCooldown((Item)this)) {
                this.setRaised((LivingEntity)player, true);
            }
        }
        super.inventoryTick(stack, level, entity, i, selected);
    }

    public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public float calcBonusDamage(Entity entity, float speed) {
        float bonusdamage = 3.0f * this.getTotalMass(entity) * speed;
        return Math.min(Math.max(0.0f, bonusdamage), 0.7f * this.attackDamage);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"lance.rideronly").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"lance.leftclick").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"lance.bonusdamage").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
    }

    public float getVelocityProjection(Entity entity) {
        Vec3 velocity = entity.isPassenger() ? entity.getRootVehicle().getDeltaMovement() : entity.getDeltaMovement();
        Vec3 vec = entity.getViewVector(1.0f);
        if (vec.lengthSqr() == 0.0) {
            return 0.0f;
        }
        return (float)(velocity.dot(vec) / vec.length());
    }

    public float getTotalMass(Entity entity) {
        float totalmass = this.getMass(entity);
        Entity entity2 = entity;
        while (entity2.isPassenger()) {
            entity2 = entity2.getVehicle();
            totalmass += this.getMass(entity2);
        }
        for (Entity passenger : entity.getPassengers()) {
            totalmass += this.getMass(passenger);
        }
        return totalmass;
    }

    public float getMass(Entity entity) {
        float mass = 0.0f;
        AABB box = entity.getBoundingBox();
        mass = (float)((double)mass + box.getXsize() * box.getYsize() * box.getZsize());
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            for (ItemStack armorpiece : livingentity.getArmorSlots()) {
                if (armorpiece.isEmpty() || !(armorpiece.getItem() instanceof ArmorItem)) continue;
                mass = (float)((double)mass + (double)((float)((ArmorItem)armorpiece.getItem()).getDefense() + ((ArmorItem)armorpiece.getItem()).getToughness()) / 20.0);
            }
        }
        return mass;
    }

    public void onBroken(Player player) {
        if (player.getMainHandItem().getItem() == this) {
            for (ItemStack stack : this.dropItems) {
                player.drop(stack, true);
            }
            player.playSound(SoundEvents.ITEM_BREAK, 1.0f, 1.0f);
        }
    }

    public boolean isRaised(@Nullable LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        ItemStack stack = entity.getMainHandItem();
        Integer raised = (Integer)stack.get((DataComponentType)ModDataComponents.RAISED.get());
        return raised != null && raised == 1;
    }

    public void setRaised(LivingEntity entity, boolean raised) {
        ItemStack stack = entity.getMainHandItem();
        stack.set((DataComponentType)ModDataComponents.RAISED.get(), (Object)(raised ? 1 : 0));
    }

    public boolean getDismount(ItemStack stack) {
        Boolean dismount = (Boolean)stack.get((DataComponentType)ModDataComponents.DISMOUNT.get());
        return dismount != null ? dismount : false;
    }

    public void setDismount(ItemStack stack, boolean dismount) {
        stack.set((DataComponentType)ModDataComponents.DISMOUNT.get(), (Object)dismount);
    }

    public float getRideSpeed(ItemStack stack) {
        Float speed = (Float)stack.get((DataComponentType)ModDataComponents.RIDE_SPEED.get());
        return speed != null ? speed.floatValue() : 0.0f;
    }

    public void setRideSpeed(ItemStack stack, float speed) {
        stack.set((DataComponentType)ModDataComponents.RIDE_SPEED.get(), (Object)Float.valueOf(speed));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)"raised"), (stack, level, entity, i) -> this.isRaised(entity) ? 1.0f : 0.0f);
    }
}

