/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.tileentity;

import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.item.MedievalShieldModel;
import com.magistuarmory.client.render.tileentity.ShieldPatternLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeraldryItemStackRenderer
extends BlockEntityWithoutLevelRenderer
implements ShieldPatternLayer {
    private Model model;
    private final ResourceLocation location;
    private final String patternsDirectory;
    private final Material baseWithPatternMaterial;
    private final Material baseWithoutPatternMaterial;
    private final Material basePatternMaterial;

    public HeraldryItemStackRenderer(String id, ResourceLocation location) {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        this.location = location;
        this.patternsDirectory = "entity/" + location.getPath() + "/";
        this.baseWithPatternMaterial = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("entity/" + id + "_pattern")));
        this.baseWithoutPatternMaterial = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("entity/" + id + "_nopattern")));
        this.basePatternMaterial = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)(this.patternsDirectory + "base")));
    }

    public void loadModel(EntityRendererProvider.Context context) {
        this.model = new MedievalShieldModel(context.bakeLayer(ModModels.createLocation(this.location)));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transform, PoseStack pose, MultiBufferSource buffer, int p, int overlay) {
        Model model = this.model;
        if (model instanceof MedievalShieldModel) {
            MedievalShieldModel shieldmodel = (MedievalShieldModel)model;
            pose.pushPose();
            pose.scale(1.0f, -1.0f, -1.0f);
            DyeColor basecolor = (DyeColor)stack.get(DataComponents.BASE_COLOR);
            VertexConsumer vertexconsumer = this.getBaseMaterial(basecolor != null).sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getBaseMaterial(basecolor != null).atlasLocation()), (boolean)true, (boolean)stack.hasFoil()));
            shieldmodel.handle().render(pose, vertexconsumer, p, overlay, 0xFFFFFF);
            BannerPatternLayers patterns = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
            ArrayList list = patterns == null ? new ArrayList() : patterns.layers().stream().map(l -> Pair.of((Object)l.pattern(), (Object)l.color())).collect(Collectors.toList());
            this.renderPatterns(pose, buffer, p, overlay, list, stack.hasFoil(), shieldmodel.plate(), basecolor);
            pose.popPose();
        }
    }

    @Override
    public Material getBaseMaterial(boolean withPattern) {
        return withPattern ? this.baseWithPatternMaterial : this.baseWithoutPatternMaterial;
    }

    @Override
    public Material getBasePatternMaterial() {
        return this.basePatternMaterial;
    }

    @Override
    public Material getPatternMaterial(ResourceLocation patternlocation) {
        return new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)(this.patternsDirectory + patternlocation.getPath())));
    }
}

