/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.entity.layer;

import com.magistuarmory.client.render.entity.layer.ArmorPatternLayer;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.decoration.HorseArmorDecorationModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseArmorDecorationLayer
extends RenderLayer<Horse, HorseModel<Horse>>
implements ArmorPatternLayer {
    private static final String BASE_DIR = "textures/entity/horse/armor/";
    private final HorseArmorDecorationModel<Horse> model;
    private final ResourceLocation baseTexture;
    private final ResourceLocation basePatternTexture;
    private final String name;
    private final String dirprefix;

    public HorseArmorDecorationLayer(RenderLayerParent<Horse, HorseModel<Horse>> parent, EntityRendererProvider.Context context, ResourceLocation texture, String name) {
        super(parent);
        this.name = name;
        this.dirprefix = BASE_DIR + name + "/";
        this.baseTexture = texture;
        this.model = new HorseArmorDecorationModel(context.bakeLayer(ModModels.createDecorationLocation(ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)name))));
        this.basePatternTexture = ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)(this.dirprefix + "base.png"));
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int p, Horse entity, float f, float f2, float f3, float f4, float f5, float f6) {
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.BODY);
        if (stack.getItem() instanceof AnimalArmorItem) {
            DyeColor basecolor = (DyeColor)stack.get(DataComponents.BASE_COLOR);
            BannerPatternLayers patterns = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
            ((HorseModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((AbstractHorse)entity, f, f2, f3);
            this.model.setupAnim((AbstractHorse)entity, f, f2, f4, f5, f6);
            ArrayList list = patterns == null ? new ArrayList() : patterns.layers().stream().map(l -> Pair.of((Object)l.pattern(), (Object)l.color())).collect(Collectors.toList());
            this.renderPatterns(pose, buffer, p, OverlayTexture.NO_OVERLAY, list, false, this.model.parts(), basecolor);
        }
    }

    @Override
    public ResourceLocation getBaseTexture(boolean withPattern) {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getBasePatternTexture() {
        return this.basePatternTexture;
    }

    @Override
    public ResourceLocation getPatternTexture(ResourceLocation patternlocation) {
        return ResourceLocation.fromNamespaceAndPath((String)this.baseTexture.getNamespace(), (String)(this.dirprefix + patternlocation.getPath() + ".png"));
    }
}

