/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render;

import com.magistuarmory.api.item.ModItemsProvider;
import com.magistuarmory.client.render.neoforge.ModRenderImpl;
import com.magistuarmory.client.render.tileentity.HeraldryItemStackRenderer;
import com.magistuarmory.client.render.tileentity.PaviseBlockRenderer;
import com.magistuarmory.item.DyeableItemLike;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.item.ModItems;
import com.magistuarmory.item.PaviseItem;
import com.magistuarmory.item.armor.MedievalArmorItem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModRender {
    public static void setup(ModItemsProvider content) {
        for (RegistrySupplier<? extends DyeableItemLike> registrySupplier : content.dyeableItems) {
            ColorHandlerRegistry.registerItemColors((stack, i) -> i > 0 ? -1 : ((DyeableItemLike)stack.getItem()).getColor(stack), (ItemLike[])new ItemLike[]{(ItemLike)registrySupplier.get()});
        }
        for (RegistrySupplier registrySupplier : content.items) {
            Object object = registrySupplier.get();
            if (!(object instanceof IHasModelProperty)) continue;
            IHasModelProperty havingproperty = (IHasModelProperty)object;
            havingproperty.registerModelProperty();
        }
        ((MedievalWeaponItem)ModItems.NOBLE_SWORD.get()).registerModelProperty();
        content.shieldItems.stream().filter(s -> s.get() instanceof PaviseItem).map(s -> (PaviseItem)s.get()).forEach(p -> BlockEntityRendererRegistry.register(p.getBlock().getEntityType(), context -> new PaviseBlockRenderer(context, p.getId(), p.getLocation())));
        ModRender.setupPlatform(content);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setupPlatform(ModItemsProvider content) {
        ModRenderImpl.setupPlatform(content);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelsLoadListener(ModItemsProvider content) {
        ModRenderImpl.registerModelsLoadListener(content);
    }

    public static void registerRenderers() {
    }

    public static void loadModels(ModItemsProvider content, EntityRendererProvider.Context context) {
        for (Supplier supplier : content.shieldItems) {
            ((MedievalShieldItem)supplier.get()).loadModel(context);
        }
        for (Supplier supplier : content.armorItems) {
            ((MedievalArmorItem)supplier.get()).loadModel(context);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static HeraldryItemStackRenderer createHeraldryItemStackRenderer(String id, ResourceLocation location) {
        void var1_1;
        return ModRenderImpl.createHeraldryItemStackRenderer(id, (ResourceLocation)var1_1);
    }
}

