/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.block;

import com.magistuarmory.block.PaviseBlock;
import com.magistuarmory.block.PaviseBlockEntity;
import com.mojang.math.Axis;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class PaviseUpperCollisionBlock
extends Block {
    static final AABB COLLISION_AABB = new AABB(0.0, 0.0, 0.46875, 1.0, 0.5, 0.53125);
    static final Vector3d CENTER = new Vector3d(0.5, 0.5, 0.5);
    static final Vector3d BOXMIN = new Vector3d(0.0, 0.0, 0.0);
    static final Vector3d BOXMAX = new Vector3d(1.0, 1.0, 1.0);

    public PaviseUpperCollisionBlock() {
        super(BlockBehaviour.Properties.of().dynamicShape().noTerrainParticles().sound(SoundType.EMPTY));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader reader, BlockPos blockpos, BlockState blockstate) {
        BlockEntity blockEntity = reader.getBlockEntity(blockpos.below());
        if (blockEntity instanceof PaviseBlockEntity) {
            PaviseBlockEntity pavise = (PaviseBlockEntity)blockEntity;
            return pavise.getStack();
        }
        return ItemStack.EMPTY;
    }

    public VoxelShape getShape(BlockState blockstate, BlockGetter blockgetter, BlockPos blockpos, CollisionContext context) {
        AABB aabb = COLLISION_AABB;
        BlockEntity blockEntity = blockgetter.getBlockEntity(blockpos.below());
        if (blockEntity instanceof PaviseBlockEntity) {
            PaviseBlockEntity pavise = (PaviseBlockEntity)blockEntity;
            BlockState blockstate2 = pavise.getBlockState();
            float yrot = -RotationSegment.convertToDegrees((int)((Integer)blockstate2.getValue((Property)BannerBlock.ROTATION)));
            aabb = PaviseUpperCollisionBlock.rotateAABB(aabb, Axis.YP.rotationDegrees(yrot));
        }
        return Shapes.create((AABB)aabb);
    }

    public static AABB rotateAABB(AABB axisAlignedBB, Quaternionf quaternion) {
        Vector3d mincoords = new Vector3d(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ);
        Vector3d maxcoords = new Vector3d(axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.maxZ);
        mincoords.sub((Vector3dc)CENTER);
        maxcoords.sub((Vector3dc)CENTER);
        quaternion.transform(mincoords);
        quaternion.transform(maxcoords);
        mincoords.add((Vector3dc)CENTER).max((Vector3dc)BOXMIN);
        maxcoords.add((Vector3dc)CENTER).min((Vector3dc)BOXMAX);
        return new AABB(mincoords.x(), mincoords.y(), mincoords.z(), maxcoords.x(), maxcoords.y(), maxcoords.z());
    }

    public void destroy(LevelAccessor accessor, BlockPos blockpos, BlockState blockstate) {
        PaviseBlockEntity pavise;
        BlockEntity blockentity = accessor.getBlockEntity(blockpos.below());
        if (blockentity instanceof PaviseBlockEntity && (pavise = (PaviseBlockEntity)blockentity).getLevel() != null) {
            accessor.addFreshEntity((Entity)new ItemEntity(pavise.getLevel(), (double)blockpos.getX() + 0.5, (double)blockpos.getY() - 0.5, (double)blockpos.getZ() + 0.5, pavise.getStack()));
        }
        if (accessor.getBlockState(blockpos.below()).getBlock() instanceof PaviseBlock) {
            accessor.destroyBlock(blockpos.below(), false);
        }
        super.destroy(accessor, blockpos, blockstate);
    }
}

