/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.block;

import com.magistuarmory.item.PaviseItem;
import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PaviseBlockEntity
extends BlockEntity {
    String shieldId;
    @Nullable
    private DyeColor baseColor;
    private BannerPatternLayers patterns = BannerPatternLayers.EMPTY;
    private boolean enchanted = false;
    private CompoundTag stackCompound;

    public PaviseBlockEntity(Supplier<BlockEntityType<PaviseBlockEntity>> type, BlockPos blockpos, BlockState blockstate) {
        super(type.get(), blockpos, blockstate);
    }

    public BannerPatternLayers getPatterns() {
        return this.patterns;
    }

    public void fromItem(ItemStack stack) {
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        Item item = stack.getItem();
        if (!(item instanceof PaviseItem)) {
            return;
        }
        PaviseItem paviseitem = (PaviseItem)item;
        ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        this.enchanted = enchantments != null && !enchantments.isEmpty();
        this.shieldId = paviseitem.getId();
        this.baseColor = (DyeColor)stack.get(DataComponents.BASE_COLOR);
        this.patterns = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
        this.stackCompound = (CompoundTag)stack.save((HolderLookup.Provider)this.getLevel().registryAccess());
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putString("ShieldId", this.shieldId);
        if (this.baseColor != null) {
            compound.putInt("Base", this.baseColor.getId());
        }
        compound.putBoolean("Enchanted", this.enchanted);
        if (this.stackCompound != null) {
            compound.put("ItemStack", (Tag)this.stackCompound);
        }
        if (this.patterns != null) {
            compound.put("patterns", (Tag)BannerPatternLayers.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.patterns).getOrThrow());
        }
    }

    public boolean hasFoil() {
        return this.enchanted;
    }

    public boolean isPainted() {
        return this.getBaseColor() != null;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.shieldId = compound.getString("ShieldId");
        if (compound.contains("Base")) {
            this.baseColor = DyeColor.byId((int)compound.getInt("Base"));
        }
        this.stackCompound = compound.getCompound("ItemStack");
        this.enchanted = compound.getBoolean("Enchanted");
        if (compound.contains("patterns")) {
            BannerPatternLayers.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("patterns")).resultOrPartial(string -> {}).ifPresent(patterns -> {
                this.patterns = patterns;
            });
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public ItemStack getStack() {
        if (this.getLevel() == null) {
            return ItemStack.EMPTY;
        }
        return ItemStack.parse((HolderLookup.Provider)this.getLevel().registryAccess(), (Tag)this.stackCompound).orElse(ItemStack.EMPTY);
    }

    public DyeColor getBaseColor() {
        return this.baseColor;
    }

    public String getShieldId() {
        return this.shieldId;
    }
}

