/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.platform;

import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.network.SPacketNotify;
import com.illusivesoulworks.veinmining.common.platform.services.IPlatform;
import com.illusivesoulworks.veinmining.common.veinmining.VeinMiningPlayers;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgePlatform
implements IPlatform {
    @Override
    public void sendNotifyS2C(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SPacketNotify.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Set<String> getBlocksFromTag(ResourceLocation resourceLocation) {
        HashSet<String> result = new HashSet<String>();
        BuiltInRegistries.BLOCK.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation)).ifPresent(block -> {
            for (Holder blockHolder : block) {
                blockHolder.unwrapKey().ifPresent(key -> result.add(key.location().toString()));
            }
        });
        return result;
    }

    @Override
    public Block getBlock(ResourceLocation resourceLocation) {
        return (Block)BuiltInRegistries.BLOCK.get(resourceLocation);
    }

    @Override
    public Optional<ResourceLocation> getResourceLocation(Block block) {
        return Optional.of(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    @Override
    public boolean canHarvestDrops(ServerPlayer playerEntity, BlockState state, BlockPos pos) {
        return EventHooks.doPlayerHarvestCheck((Player)playerEntity, (BlockState)state, (BlockGetter)playerEntity.level(), (BlockPos)pos);
    }

    @Override
    public boolean harvest(ServerPlayer player, BlockPos pos, BlockPos originPos) {
        ServerLevel world = player.serverLevel();
        BlockState blockstate = world.getBlockState(pos);
        GameType gameType = player.gameMode.getGameModeForPlayer();
        BlockEvent.BreakEvent evt = CommonHooks.fireBlockBreak((Level)world, (GameType)gameType, (ServerPlayer)player, (BlockPos)pos, (BlockState)blockstate);
        if (evt.isCanceled()) {
            return false;
        }
        BlockEntity blockentity = world.getBlockEntity(pos);
        Block block = blockstate.getBlock();
        if (block instanceof GameMasterBlock && !player.canUseGameMasterBlocks()) {
            world.sendBlockUpdated(pos, blockstate, blockstate, 3);
            return false;
        }
        if (player.blockActionRestricted((Level)world, pos, gameType)) {
            return false;
        }
        if (gameType.isCreative()) {
            NeoForgePlatform.removeBlock((Player)player, pos, false);
        } else {
            BlockPos spawnPos;
            ItemStack itemstack = player.getMainHandItem();
            ItemStack itemstack1 = itemstack.copy();
            boolean flag1 = blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player);
            itemstack.mineBlock((Level)world, blockstate, pos, (Player)player);
            if (itemstack.isEmpty() && !itemstack1.isEmpty()) {
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
            }
            boolean flag = NeoForgePlatform.removeBlock((Player)player, pos, flag1);
            BlockPos blockPos = spawnPos = (Boolean)VeinMiningConfig.SERVER.relocateDrops.get() != false ? originPos : pos;
            if (flag && flag1) {
                FoodData foodData = player.getFoodData();
                float currentExhaustion = foodData.getExhaustionLevel();
                VeinMiningPlayers.addMiningBlock((Level)world, pos, spawnPos);
                block.playerDestroy((Level)world, (Player)player, pos, blockstate, blockentity, itemstack1);
                VeinMiningPlayers.removeMiningBlock((Level)world, pos);
                if (((Boolean)VeinMiningConfig.SERVER.addExhaustion.get()).booleanValue()) {
                    float diff = foodData.getExhaustionLevel() - currentExhaustion;
                    foodData.setExhaustion(currentExhaustion);
                    foodData.addExhaustion((float)((double)diff * (Double)VeinMiningConfig.SERVER.exhaustionMultiplier.get()));
                } else {
                    foodData.setExhaustion(currentExhaustion);
                }
            }
        }
        return true;
    }

    private static boolean removeBlock(Player player, BlockPos pos, boolean canHarvest) {
        Level world = player.getCommandSenderWorld();
        BlockState state = world.getBlockState(pos);
        boolean removed = state.onDestroyedByPlayer(world, pos, player, canHarvest, world.getFluidState(pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)world, pos, state);
        }
        return removed;
    }
}

