/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer;

import com.google.gson.Gson;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.sinytra.connector.transformer.MappingAwareReferenceMapper;
import org.slf4j.Logger;
import reloc.net.minecraftforge.fart.api.Transformer;

public class RefmapRemapper
implements Transformer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final String INTERMEDIARY_MAPPING_ENV = "named:intermediary";
    private static final String MOJ_MAPPING_ENV = "mojang";
    private final Map<String, MappingAwareReferenceMapper.SimpleRefmap> files;

    public static RefmapFiles processRefmaps(Path input, Collection<String> refmaps, MappingAwareReferenceMapper remapper, List<Path> libs) throws IOException {
        MappingAwareReferenceMapper.SimpleRefmap results = new MappingAwareReferenceMapper.SimpleRefmap(Map.of(), Map.of());
        HashMap<String, MappingAwareReferenceMapper.SimpleRefmap> refmapFiles = new HashMap<String, MappingAwareReferenceMapper.SimpleRefmap>();
        try (FileSystem fs = FileSystems.newFileSystem(input);){
            for (String refmap : refmaps) {
                Path refmapPath = fs.getPath(refmap, new String[0]);
                if (Files.notExists(refmapPath, new LinkOption[0])) {
                    refmapPath = RefmapRemapper.findRefmapOnClasspath(refmap, input, libs);
                }
                if (refmapPath != null) {
                    byte[] data = Files.readAllBytes(refmapPath);
                    MappingAwareReferenceMapper.SimpleRefmap remapped = RefmapRemapper.remapRefmapInPlace(data, remapper);
                    refmapFiles.put(refmap, remapped);
                    results = results.merge(remapped);
                    continue;
                }
                LOGGER.warn("Refmap remapper could not find refmap file {}", (Object)refmap);
            }
        }
        return new RefmapFiles(results, refmapFiles);
    }

    @Nullable
    private static Path findRefmapOnClasspath(String resource, Path exclude, List<Path> libs) {
        for (Path lib : libs) {
            Path path;
            Path basePath;
            if (lib == exclude) continue;
            if (Files.isDirectory(lib, new LinkOption[0])) {
                basePath = lib;
            } else {
                try {
                    FileSystem fs = FileSystems.newFileSystem(lib);
                    basePath = fs.getPath("", new String[0]);
                }
                catch (Exception e) {
                    LOGGER.error("Error opening jar file", (Throwable)e);
                    return null;
                }
            }
            if (!Files.exists(path = basePath.resolve(resource), new LinkOption[0])) continue;
            return path;
        }
        return null;
    }

    public RefmapRemapper(Map<String, MappingAwareReferenceMapper.SimpleRefmap> files) {
        this.files = files;
    }

    @Override
    public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
        String name = entry.getName();
        if (this.files.containsKey(name)) {
            Transformer.ResourceEntry resourceEntry;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                try (OutputStreamWriter writer = new OutputStreamWriter(byteStream);){
                    this.files.get(name).write(writer);
                    ((Writer)writer).flush();
                }
                byte[] data = byteStream.toByteArray();
                resourceEntry = Transformer.ResourceEntry.create(name, entry.getTime(), data);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        byteStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            byteStream.close();
            return resourceEntry;
        }
        return entry;
    }

    private static MappingAwareReferenceMapper.SimpleRefmap remapRefmapInPlace(byte[] data, MappingAwareReferenceMapper remapper) {
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(data));
        MappingAwareReferenceMapper.SimpleRefmap simpleRefmap = (MappingAwareReferenceMapper.SimpleRefmap)GSON.fromJson((Reader)reader, MappingAwareReferenceMapper.SimpleRefmap.class);
        Map<String, String> replacements = Map.of(INTERMEDIARY_MAPPING_ENV, MOJ_MAPPING_ENV);
        return remapper.remap(simpleRefmap, replacements);
    }

    public record RefmapFiles(MappingAwareReferenceMapper.SimpleRefmap merged, Map<String, MappingAwareReferenceMapper.SimpleRefmap> files) {
    }
}

