/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.neoforged.fml.loading.moddiscovery.readers.JarModsDotTomlModFileReader;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.MarkerFilter;
import org.sinytra.connector.service.DummyVirtualJar;
import org.slf4j.Logger;

public class ConnectorEarlyLocatorBootstrap
implements IModFileCandidateLocator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ILaunchContext launchContext;

    public ConnectorEarlyLocatorBootstrap() {
        ConnectorEarlyLocatorBootstrap.injectLogMarkers();
    }

    public static ILaunchContext getLaunchContext() {
        return launchContext;
    }

    private static void injectLogMarkers() {
        String markerselection = System.getProperty("connector.logging.markers", "");
        Arrays.stream(markerselection.split(",")).forEach(marker -> System.setProperty("connector.logging.marker." + marker.toLowerCase(Locale.ROOT), "ACCEPT"));
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getLogger(ConnectorEarlyLocatorBootstrap.class);
        Configuration config = logger.getContext().getConfiguration();
        config.addFilter((Filter)MarkerFilter.createFilter((String)"MIXINPATCH", (Filter.Result)ConnectorEarlyLocatorBootstrap.parseLogMarker("connector.logging.marker.mixinpatch"), (Filter.Result)Filter.Result.NEUTRAL));
        logger.getContext().updateLoggers();
    }

    private static Filter.Result parseLogMarker(String propertyName) {
        String value = System.getProperty(propertyName, "DENY");
        return Filter.Result.valueOf((String)value);
    }

    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        launchContext = context;
        pipeline.addModFile(ConnectorEarlyLocatorBootstrap.overrideFabricLoaderMod());
    }

    private static IModFile overrideFabricLoaderMod() {
        DummyVirtualJar secureJar = new DummyVirtualJar("net.fabricmc.loader", "dummy_forgified_fabric_loader", Set.of(), () -> {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_VERSION, "999.999.999");
            return manifest;
        }, s -> Optional.empty());
        return IModFile.create((SecureJar)secureJar, JarModsDotTomlModFileReader::manifestParser, (IModFile.Type)IModFile.Type.LIBRARY, (ModFileDiscoveryAttributes)ModFileDiscoveryAttributes.DEFAULT);
    }
}

