/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.sinytra.adapter.patch.transformer.operation.ModifyInjectionTarget;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.OpcodeUtil;

public class DynFixSplitMethod
implements DynamicFixer<Data> {
    private static final String DEPRECATED = "Ljava/lang/Deprecated;";

    @Override
    @Nullable
    public Data prepare(MethodContext methodContext) {
        if (methodContext.hasInjectionPointValue("INVOKE") && methodContext.findCleanInjectionTarget() != null && methodContext.findDirtyInjectionTarget() != null) {
            return new Data();
        }
        return null;
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, Data data) {
        List<MethodNode> candidates = DynFixSplitMethod.locateCandidates(methodContext);
        if (candidates.size() == 1) {
            MethodNode method = candidates.getFirst();
            String newTarget = method.name + method.desc;
            methodContext.recordAudit(this, "Adjusting split method target to %s", newTarget);
            return DynamicFixer.FixResult.of(new ModifyInjectionTarget(List.of(newTarget)).apply(methodContext), PatchAuditTrail.Match.FULL);
        }
        return null;
    }

    private static List<MethodNode> locateCandidates(MethodContext methodContext) {
        MethodNode cleanTargetMethod = methodContext.findCleanInjectionTarget().methodNode();
        ClassNode dirtyTargetClass = methodContext.findDirtyInjectionTarget().classNode();
        MethodNode dirtyTargetMethod = methodContext.findDirtyInjectionTarget().methodNode();
        if (AdapterUtil.hasAnnotation(cleanTargetMethod.visibleAnnotations, DEPRECATED) || !AdapterUtil.hasAnnotation(dirtyTargetMethod.visibleAnnotations, DEPRECATED)) {
            return DynFixSplitMethod.tryFindPartialCandidates(cleanTargetMethod, dirtyTargetClass, dirtyTargetMethod, methodContext);
        }
        ArrayList<MethodNode> invocations = new ArrayList<MethodNode>();
        for (int i = 1; i < dirtyTargetMethod.instructions.size() - 1; ++i) {
            AbstractInsnNode insn = dirtyTargetMethod.instructions.get(i);
            if (!(insn instanceof LabelNode)) continue;
            AbstractInsnNode previous = insn.getPrevious();
            if (previous instanceof MethodInsnNode) {
                MethodInsnNode methodInsn = (MethodInsnNode)previous;
                if (methodInsn.owner.equals(dirtyTargetClass.name)) {
                    MethodNode method = dirtyTargetClass.methods.stream().filter(m -> m.name.equals(methodInsn.name) && m.desc.equals(methodInsn.desc)).findFirst().orElseThrow();
                    invocations.add(method);
                    continue;
                }
            }
            if (previous != null && OpcodeUtil.isReturnOpcode(previous.getOpcode())) continue;
            return null;
        }
        List<MethodNode> candidates = DynFixSplitMethod.findInsnsCalls(invocations, methodContext);
        if (candidates.isEmpty()) {
            List<MethodNode> nestedLambdas = invocations.stream().flatMap(m -> MethodCallAnalyzer.findLambdasInMethod(dirtyTargetClass, m, null).stream()).flatMap(s -> MethodCallAnalyzer.findMethodByUniqueName(dirtyTargetClass, s).stream()).toList();
            return DynFixSplitMethod.findInsnsCalls(nestedLambdas, methodContext);
        }
        return candidates;
    }

    private static List<MethodNode> tryFindPartialCandidates(MethodNode cleanTargetMethod, ClassNode dirtyTargetClass, MethodNode dirtyTargetMethod, MethodContext methodContext) {
        Multimap<String, MethodInsnNode> cleanMethodCalls = MethodCallAnalyzer.getMethodCalls(cleanTargetMethod, new ArrayList<String>());
        Multimap<String, MethodInsnNode> dirtyMethodCalls = MethodCallAnalyzer.getMethodCalls(dirtyTargetMethod, new ArrayList<String>());
        List<MethodNode> dirtyOnlyCalls = dirtyMethodCalls.entries().stream().filter(e -> !cleanMethodCalls.containsKey(e.getKey()) && ((MethodInsnNode)e.getValue()).owner.equals(dirtyTargetClass.name)).map(Map.Entry::getValue).flatMap(i -> MethodCallAnalyzer.findMethodByNameOrThrow(dirtyTargetClass, i.name, i.desc).stream()).toList();
        return DynFixSplitMethod.findInsnsCalls(dirtyOnlyCalls, methodContext);
    }

    private static List<MethodNode> findInsnsCalls(List<MethodNode> methods, MethodContext methodContext) {
        ClassNode dirtyTargetClass = methodContext.findDirtyInjectionTarget().classNode();
        return methods.stream().filter(method -> !methodContext.findInjectionTargetInsns(new MethodContext.TargetPair(dirtyTargetClass, (MethodNode)method)).isEmpty()).toList();
    }

    public record Data() {
    }
}

