/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import com.google.common.collect.HashMultimap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.analysis.MethodLabelComparator;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.fixes.MethodUpgrader;
import org.sinytra.adapter.patch.transformer.BundledMethodTransform;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.sinytra.adapter.patch.transformer.dynfix.MirrorableExtractMixin;
import org.sinytra.adapter.patch.transformer.operation.ModifyInjectionPoint;
import org.sinytra.adapter.patch.transformer.operation.param.InjectParameterTransform;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformationUtil;
import org.sinytra.adapter.patch.transformer.operation.param.RemoveParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.ReplaceParametersTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.TransformParameters;
import org.sinytra.adapter.patch.transformer.pipeline.MethodTransformationPipeline;
import org.sinytra.adapter.patch.util.AdapterUtil;

public class DynFixMethodComparison
implements DynamicFixer<Data> {
    private static final Set<String> ACCEPTED_ANNOTATIONS = Set.of("Lorg/spongepowered/asm/mixin/injection/Inject;", "Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;");

    @Override
    @Nullable
    public Data prepare(MethodContext methodContext) {
        if (methodContext.methodAnnotation().matchesAny(ACCEPTED_ANNOTATIONS) && methodContext.findDirtyInjectionTarget() != null) {
            MethodContext.TargetPair cleanInjectionTarget = methodContext.findCleanInjectionTarget();
            if (cleanInjectionTarget == null) {
                return null;
            }
            List<AbstractInsnNode> cleanInsns = methodContext.findInjectionTargetInsns(cleanInjectionTarget);
            if (!cleanInsns.isEmpty()) {
                return new Data(cleanInsns.getFirst());
            }
        }
        return null;
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, Data data) {
        MethodInsnNode minsn;
        AbstractInsnNode cleanInjectionInsn = data.cleanInjectionInsn();
        MethodLabelComparator.ComparisonResult comparisonResult = MethodLabelComparator.findPatchedLabels(cleanInjectionInsn, methodContext);
        if (comparisonResult == null) {
            return null;
        }
        List<List<AbstractInsnNode>> hunkLabels = comparisonResult.patchedLabels();
        if (methodContext.methodAnnotation().matchesDesc("Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;")) {
            return DynFixMethodComparison.handleWrapOperationToInstanceOf(cleanInjectionInsn, comparisonResult.cleanLabel(), hunkLabels, methodContext).or(() -> DynFixMethodComparison.handleWrapOpertationNewInjectionPoint(cleanInjectionInsn, comparisonResult.cleanLabel(), hunkLabels, methodContext)).or(() -> DynFixMethodComparison.handleTargetModification(hunkLabels, methodContext)).orElse(null);
        }
        ClassNode cleanTargetClass = methodContext.findCleanInjectionTarget().classNode();
        for (List<AbstractInsnNode> insns : hunkLabels) {
            for (AbstractInsnNode insn : insns) {
                Patch.Result result;
                if (!(insn instanceof MethodInsnNode) || (minsn = (MethodInsnNode)insn).getOpcode() != 184 || minsn.owner.equals(cleanTargetClass.name) || (result = DynFixMethodComparison.attemptExtractMixin(minsn, methodContext)) == Patch.Result.PASS) continue;
                return DynamicFixer.FixResult.of(result, PatchAuditTrail.Match.FULL);
            }
        }
        for (List<AbstractInsnNode> insns : hunkLabels) {
            for (AbstractInsnNode insn : insns) {
                if (!(insn instanceof MethodInsnNode)) continue;
                minsn = (MethodInsnNode)insn;
                String newInjectionPoint = Type.getObjectType((String)minsn.owner).getDescriptor() + minsn.name + minsn.desc;
                return DynamicFixer.FixResult.of(new ModifyInjectionPoint("INVOKE", newInjectionPoint, true, false).apply(methodContext), PatchAuditTrail.Match.PARTIAL);
            }
        }
        return null;
    }

    private static Optional<DynamicFixer.FixResult> handleWrapOpertationNewInjectionPoint(AbstractInsnNode cleanInjectionInsn, List<AbstractInsnNode> cleanLabel, List<List<AbstractInsnNode>> hunkLabels, MethodContext methodContext) {
        MethodInsnNode minsn;
        block5: {
            block4: {
                if (!(cleanInjectionInsn instanceof MethodInsnNode)) break block4;
                minsn = (MethodInsnNode)cleanInjectionInsn;
                if (hunkLabels.size() == 1) break block5;
            }
            return Optional.empty();
        }
        Type cleanReturnType = Type.getReturnType((String)minsn.desc);
        List<AbstractInsnNode> dirtyLabel = hunkLabels.getFirst();
        List<String> cleanMethodCalls = cleanLabel.stream().filter(i -> {
            if (!(i instanceof MethodInsnNode)) return false;
            MethodInsnNode m = (MethodInsnNode)i;
            if (!m.owner.equals(minsn.owner)) return false;
            if (!Type.getReturnType((String)m.desc).equals((Object)cleanReturnType)) return false;
            return true;
        }).map(i -> ((MethodInsnNode)i).name).toList();
        List<MethodInsnNode> methodCalls = dirtyLabel.stream().filter(i -> {
            if (!(i instanceof MethodInsnNode)) return false;
            MethodInsnNode m = (MethodInsnNode)i;
            if (!m.owner.equals(minsn.owner)) return false;
            if (!Type.getReturnType((String)m.desc).equals((Object)cleanReturnType)) return false;
            if (cleanMethodCalls.contains(m.name)) return false;
            return true;
        }).map(i -> (MethodInsnNode)i).toList();
        if (methodCalls.size() != 1) {
            return Optional.empty();
        }
        MethodInsnNode dirtyMinsn = methodCalls.getFirst();
        return Optional.of(DynamicFixer.FixResult.of(((BundledMethodTransform.Builder)BundledMethodTransform.builder().modifyInjectionPoint("INVOKE", MethodCallAnalyzer.getCallQualifier(dirtyMinsn))).apply(methodContext), PatchAuditTrail.Match.FULL));
    }

    private static Optional<DynamicFixer.FixResult> handleWrapOperationToInstanceOf(AbstractInsnNode cleanInjectionInsn, List<AbstractInsnNode> cleanLabel, List<List<AbstractInsnNode>> hunkLabels, MethodContext methodContext) {
        Object varInsn2;
        MethodInsnNode minsn;
        block16: {
            block15: {
                if (!(cleanInjectionInsn instanceof MethodInsnNode)) break block15;
                minsn = (MethodInsnNode)cleanInjectionInsn;
                if (hunkLabels.size() == 1 && cleanLabel.getLast() instanceof JumpInsnNode && !cleanLabel.stream().anyMatch(i -> i instanceof TypeInsnNode)) break block16;
            }
            return Optional.empty();
        }
        List<AbstractInsnNode> dirtyLabel = hunkLabels.getFirst();
        if (!(dirtyLabel.getLast() instanceof JumpInsnNode)) {
            return Optional.empty();
        }
        List<TypeInsnNode> instanceOfCalls = dirtyLabel.stream().filter(i -> i instanceof TypeInsnNode).map(i -> (TypeInsnNode)i).toList();
        if (instanceOfCalls.size() != 1) {
            return Optional.empty();
        }
        TypeInsnNode instanceOfCall = instanceOfCalls.getFirst();
        MethodNode methodNode = methodContext.getMixinMethod();
        LocalVariableLookup mixinLocals = new LocalVariableLookup(methodNode);
        Type[] argsTypes = Type.getArgumentTypes((String)methodNode.desc);
        HashSet<Integer> paramVars = new HashSet<Integer>();
        for (int i2 = 0; i2 < argsTypes.length && !argsTypes[i2].equals((Object)AdapterUtil.OPERATION_TYPE); ++i2) {
            LocalVariableNode lvn = mixinLocals.getByParameterOrdinal(i2);
            paramVars.add(lvn.index);
        }
        ParamTransformationUtil.extractWrapOperation(methodContext, methodNode, List.of(argsTypes), op -> {
            for (int i = 1; i < paramVars.size(); ++i) {
                op.removeParameter(i);
            }
        });
        List<AbstractInsnNode> originalOpCall = ParamTransformationUtil.findWrapOperationOriginalCallArgs(methodNode, methodContext);
        HashMultimap usedVars = HashMultimap.create();
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (!(insn instanceof VarInsnNode)) continue;
            varInsn2 = (VarInsnNode)insn;
            if (originalOpCall.contains(insn) || !paramVars.contains(((VarInsnNode)varInsn2).var)) continue;
            usedVars.put((Object)((VarInsnNode)varInsn2).var, varInsn2);
        }
        List<AbstractInsnNode> originalCallArgs = MethodCallAnalyzer.findMethodCallParamInsns(methodContext.findCleanInjectionTarget().methodNode(), minsn);
        LocalVariableNode instanceLocal = mixinLocals.getByParameterOrdinal(0);
        varInsn2 = usedVars.keySet().iterator();
        while (varInsn2.hasNext()) {
            String string;
            int paramVar = (Integer)varInsn2.next();
            if (paramVar == instanceLocal.index) {
                int cleanOrdinal = methodContext.cleanLocalsTable().getTypedOrdinal(methodContext.cleanLocalsTable().getByIndex(((VarInsnNode)originalCallArgs.getFirst()).var)).orElse(-1);
                if (cleanOrdinal == -1) {
                    return Optional.empty();
                }
                LocalVariableNode dirtyLocal = methodContext.dirtyLocalsTable().getByTypedOrdinal(Type.getType((String)instanceLocal.desc), cleanOrdinal).orElse(null);
                if (dirtyLocal == null) {
                    return Optional.empty();
                }
                TransformParameters.builder().transform(new InjectParameterTransform(argsTypes.length, Type.getType((String)dirtyLocal.desc), false)).build().apply(methodContext);
                int newOrdinal = Type.getArgumentTypes((String)methodNode.desc).length - 1;
                AnnotationVisitor visitor = methodNode.visitParameterAnnotation(newOrdinal, "Lcom/llamalad7/mixinextras/sugar/Local;", false);
                visitor.visit("ordinal", (Object)cleanOrdinal);
                visitor.visitEnd();
                int newIndex = new LocalVariableLookup((MethodNode)methodNode).getByParameterOrdinal((int)newOrdinal).index;
                usedVars.get((Object)paramVar).forEach(varInsn -> {
                    varInsn.var = newIndex;
                });
                continue;
            }
            AbstractInsnNode abstractInsnNode = instanceOfCall.getPrevious();
            if (abstractInsnNode instanceof MethodInsnNode) {
                MethodInsnNode m = (MethodInsnNode)abstractInsnNode;
                string = Type.getReturnType((String)m.desc).getDescriptor();
            } else {
                string = null;
            }
            String loadedType = string;
            LocalVariableNode node = mixinLocals.getByIndex(paramVar);
            if (loadedType == null || !loadedType.equals(node.desc)) {
                return Optional.empty();
            }
            usedVars.get((Object)paramVar).forEach(varInsn -> {
                varInsn.var = instanceLocal.index;
            });
        }
        Patch.Result result = TransformParameters.builder().transform(new ReplaceParametersTransformer(0, Type.getObjectType((String)"java/lang/Object"), false)).chain(b -> {
            for (int i = 1; i < paramVars.size(); ++i) {
                b.transform(new RemoveParameterTransformer(i, false));
            }
        }).build().apply(methodContext);
        if (result == Patch.Result.PASS) {
            return Optional.empty();
        }
        AnnotationHandle ann = methodContext.methodAnnotation();
        ann.removeValues("at");
        AnnotationVisitor visitor = ann.unwrap().visitAnnotation("constant", "Lorg/spongepowered/asm/mixin/injection/Constant;");
        visitor.visit("classValue", (Object)Type.getObjectType((String)instanceOfCall.desc));
        visitor.visitEnd();
        return Optional.of(DynamicFixer.FixResult.of(Patch.Result.APPLY, PatchAuditTrail.Match.FULL));
    }

    private static Optional<DynamicFixer.FixResult> handleTargetModification(List<List<AbstractInsnNode>> hunkLabels, MethodContext methodContext) {
        ClassNode dirtyTarget = methodContext.findDirtyInjectionTarget().classNode();
        for (List<AbstractInsnNode> insns : hunkLabels) {
            for (AbstractInsnNode insn : insns) {
                MethodNode method;
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode minsn = (MethodInsnNode)insn;
                if (!minsn.owner.equals(dirtyTarget.name) || (method = (MethodNode)MethodCallAnalyzer.findMethodByUniqueName(dirtyTarget, minsn.name).orElse(null)) == null || methodContext.findInjectionTargetInsns(new MethodContext.TargetPair(dirtyTarget, method)).isEmpty()) continue;
                return Optional.of(DynamicFixer.FixResult.of(((BundledMethodTransform.Builder)BundledMethodTransform.builder().modifyTarget(minsn.name + minsn.desc)).apply(methodContext), PatchAuditTrail.Match.FULL));
            }
        }
        return Optional.empty();
    }

    private static Patch.Result attemptExtractMixin(MethodInsnNode minsn, MethodContext methodContext) {
        ClassNode targetClass = methodContext.patchContext().environment().dirtyClassLookup().getClass(minsn.owner).orElse(null);
        if (targetClass == null) {
            return Patch.Result.PASS;
        }
        MethodNode targetMethod = methodContext.patchContext().environment().dirtyClassLookup().findMethod(minsn.owner, minsn.name, minsn.desc).orElse(null);
        if (targetMethod == null) {
            return Patch.Result.PASS;
        }
        MethodUpgrader.adjustInjectorOrdinalForNewMethod(minsn, methodContext);
        List<AbstractInsnNode> newTargetInsns = methodContext.findInjectionTargetInsns(new MethodContext.TargetPair(targetClass, targetMethod));
        if (newTargetInsns.isEmpty()) {
            return Patch.Result.PASS;
        }
        return MethodTransformationPipeline.builder(b -> b.extractMixin(minsn.owner)).onSuccess(b -> b.modifyTarget(minsn.name + minsn.desc)).onFail(() -> new MirrorableExtractMixin(targetClass.name, minsn)).apply(methodContext);
    }

    public record Data(AbstractInsnNode cleanInjectionInsn) {
    }
}

