/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;
import org.objectweb.asm.tree.analysis.Value;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class MethodCallAnalyzer {
    public static final UnaryOperator<AbstractInsnNode> FORWARD = AbstractInsnNode::getNext;
    public static final UnaryOperator<AbstractInsnNode> BACKWARDS = AbstractInsnNode::getPrevious;
    public static final String LAMBDA_PREFIX = "lambda$";

    public static List<String> findLambdasInMethod(ClassNode cls, MethodNode method, @Nullable Multimap<String, MethodNode> methods) {
        ArrayList<String> list = new ArrayList<String>();
        block0: for (AbstractInsnNode insn : method.instructions) {
            if (!(insn instanceof InvokeDynamicInsnNode)) continue;
            InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
            if (indy.bsmArgs.length < 3) continue;
            for (Object bsmArg : indy.bsmArgs) {
                Handle handle;
                if (!(bsmArg instanceof Handle) || !(handle = (Handle)bsmArg).getOwner().equals(cls.name) || !handle.getName().startsWith(LAMBDA_PREFIX)) continue;
                String name = handle.getName();
                list.add(name);
                if (methods == null) continue block0;
                MethodNode lambda = MethodCallAnalyzer.findUniqueMethod(methods, name);
                list.addAll(MethodCallAnalyzer.findLambdasInMethod(cls, lambda, methods));
                continue block0;
            }
        }
        return list;
    }

    public static Optional<MethodNode> findMethodByUniqueName(ClassNode cls, String name) {
        List<MethodNode> methods = cls.methods.stream().filter(m -> m.name.equals(name)).toList();
        if (methods.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(methods.getFirst());
    }

    public static Optional<MethodNode> findMethodByNameOrThrow(ClassNode cls, String name, String desc) {
        return cls.methods.stream().filter(m -> m.name.equals(name) && m.desc.equals(desc)).findFirst();
    }

    public static Multimap<String, MethodInsnNode> getMethodCalls(MethodNode node, List<String> callOrder) {
        ImmutableMultimap.Builder calls = ImmutableMultimap.builder();
        for (AbstractInsnNode insn : node.instructions) {
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode minsn = (MethodInsnNode)insn;
            String qualifier = MethodCallAnalyzer.getCallQualifier(minsn);
            calls.put((Object)qualifier, (Object)minsn);
            callOrder.add(qualifier);
        }
        return calls.build();
    }

    public static InstructionMatcher findSurroundingInstructions(AbstractInsnNode insn, int range) {
        LabelNode previousLabel = MethodCallAnalyzer.findFirstInsn(insn, LabelNode.class, BACKWARDS);
        LabelNode nextLabel = MethodCallAnalyzer.findFirstInsn(insn, LabelNode.class, FORWARD);
        List<AbstractInsnNode> previousInsns = MethodCallAnalyzer.getInsns((AbstractInsnNode)previousLabel, range, BACKWARDS);
        List<AbstractInsnNode> nextInsns = MethodCallAnalyzer.getInsns((AbstractInsnNode)nextLabel, range, FORWARD);
        return new InstructionMatcher(insn, previousInsns, nextInsns);
    }

    public static InstructionMatcher findBackwardsInstructions(AbstractInsnNode insn, int range) {
        LabelNode previousLabel = MethodCallAnalyzer.findFirstInsn(insn, LabelNode.class, BACKWARDS);
        List<AbstractInsnNode> previousInsns = MethodCallAnalyzer.getInsns((AbstractInsnNode)previousLabel, range, BACKWARDS);
        return new InstructionMatcher(insn, previousInsns, List.of());
    }

    public static InstructionMatcher findForwardInstructions(AbstractInsnNode insn, int range) {
        LabelNode nextLabel = MethodCallAnalyzer.findFirstInsn(insn, LabelNode.class, FORWARD);
        List<AbstractInsnNode> nextInsns = MethodCallAnalyzer.getInsns((AbstractInsnNode)nextLabel, range, FORWARD);
        return new InstructionMatcher(insn, List.of(), nextInsns);
    }

    public static InstructionMatcher findForwardInstructionsDirect(AbstractInsnNode insn, int range) {
        List<AbstractInsnNode> nextInsns = MethodCallAnalyzer.getInsns(insn, range, FORWARD);
        return new InstructionMatcher(insn, List.of(), nextInsns);
    }

    private static List<AbstractInsnNode> getInsns(AbstractInsnNode root, int range, UnaryOperator<AbstractInsnNode> operator) {
        return Stream.iterate(root, Objects::nonNull, operator).filter(insn -> !(insn instanceof FrameNode) && !(insn instanceof LineNumberNode)).limit(range).toList();
    }

    @Nullable
    public static <T extends AbstractInsnNode> T findFirstInsn(AbstractInsnNode insn, Class<T> type, UnaryOperator<AbstractInsnNode> operator) {
        return (T)((AbstractInsnNode)Stream.iterate(insn, Objects::nonNull, operator).filter(type::isInstance).findFirst().orElse(null));
    }

    public static String getCallQualifier(MethodInsnNode insn) {
        return Type.getObjectType((String)insn.owner).getDescriptor() + insn.name + insn.desc;
    }

    public static List<List<AbstractInsnNode>> getInvocationInsns(MethodNode methodNode, MethodQualifier qualifier) {
        return MethodCallAnalyzer.analyzeMethod(methodNode, (insn, values) -> qualifier.matches((MethodInsnNode)insn) && values.size() > 1, (insn, values) -> {
            ArrayList<Object> insns = new ArrayList<Object>();
            for (SourceValue value : values) {
                if (value.insns.size() != 1) continue;
                insns.add((AbstractInsnNode)value.insns.iterator().next());
            }
            insns.add(insn);
            return insns;
        });
    }

    @Nullable
    public static List<AbstractInsnNode> findMethodCallParamInsns(MethodNode methodNode, MethodInsnNode insn) {
        MethodCallInterpreter interpreter = MethodCallAnalyzer.analyzeInterpretMethod(methodNode, new MethodCallInterpreter(insn));
        return interpreter.getTargetArgs();
    }

    @Nullable
    public static List<AbstractInsnNode> findFullMethodCallParamInsns(MethodNode methodNode, MethodInsnNode minsn) {
        List<AbstractInsnNode> insns = MethodCallAnalyzer.findMethodCallParamInsns(methodNode, minsn);
        if (minsn != null) {
            ArrayList<AbstractInsnNode> fullInsns = new ArrayList<AbstractInsnNode>();
            for (AbstractInsnNode i = insns.getFirst(); i != null && i != minsn; i = i.getNext()) {
                fullInsns.add(i);
            }
            return fullInsns;
        }
        return null;
    }

    public static <T> List<T> analyzeMethod(MethodNode methodNode, NaryOperationHandler<T> handler) {
        return MethodCallAnalyzer.analyzeMethod(methodNode, (insn, values) -> true, handler);
    }

    public static <T> List<T> analyzeMethod(MethodNode methodNode, BiPredicate<MethodInsnNode, List<? extends SourceValue>> filter, NaryOperationHandler<T> handler) {
        AnalysingSourceInterpreter<T> i = new AnalysingSourceInterpreter<T>(filter, handler);
        Analyzer analyzer = new Analyzer(i);
        try {
            analyzer.analyze(methodNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
        return i.getResults();
    }

    public static <T extends Interpreter<V>, V extends Value> T analyzeInterpretMethod(MethodNode methodNode, T interpreter) {
        Analyzer analyzer = new Analyzer(interpreter);
        try {
            analyzer.analyze(methodNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
        return interpreter;
    }

    @Nullable
    public static AbstractInsnNode getSingleInsn(List<? extends SourceValue> values, int index) {
        SourceValue value = values.get(index);
        return value.insns.size() == 1 ? (AbstractInsnNode)value.insns.iterator().next() : null;
    }

    public static MethodNode findUniqueMethod(Multimap<String, MethodNode> methods, String name) {
        Collection values = methods.get((Object)name);
        if (values != null && !values.isEmpty()) {
            if (values.size() > 1) {
                throw new IllegalStateException("Found multiple candidates for method " + name);
            }
            return (MethodNode)values.iterator().next();
        }
        throw new NullPointerException("Method " + name + " not found");
    }

    public static interface NaryOperationHandler<T> {
        public T accept(MethodInsnNode var1, List<? extends SourceValue> var2);
    }

    private static class MethodCallInterpreter
    extends SourceInterpreter {
        private final MethodInsnNode targetInsn;
        private List<AbstractInsnNode> targetArgs;

        public MethodCallInterpreter(MethodInsnNode targetInsn) {
            super(589824);
            this.targetInsn = targetInsn;
        }

        @javax.annotation.Nullable
        public List<AbstractInsnNode> getTargetArgs() {
            return this.targetArgs;
        }

        public SourceValue naryOperation(AbstractInsnNode insn, List<? extends SourceValue> values) {
            List<AbstractInsnNode> targetArgs;
            if (insn == this.targetInsn && this.targetArgs == null && !(targetArgs = values.stream().map(v -> v.insns.size() == 1 ? (AbstractInsnNode)v.insns.iterator().next() : null).toList()).contains(null)) {
                this.targetArgs = targetArgs;
            }
            return super.naryOperation(insn, values);
        }
    }

    private static class AnalysingSourceInterpreter<T>
    extends SourceInterpreter {
        private final BiPredicate<MethodInsnNode, List<? extends SourceValue>> filter;
        private final NaryOperationHandler<T> handler;
        private final List<T> results = new ArrayList<T>();
        private final Collection<MethodInsnNode> seen = new HashSet<MethodInsnNode>();

        public AnalysingSourceInterpreter(BiPredicate<MethodInsnNode, List<? extends SourceValue>> filter, NaryOperationHandler<T> handler) {
            super(589824);
            this.filter = filter;
            this.handler = handler;
        }

        public List<T> getResults() {
            return this.results;
        }

        public SourceValue naryOperation(AbstractInsnNode insn, List<? extends SourceValue> values) {
            T result;
            MethodInsnNode minsn;
            if (insn instanceof MethodInsnNode && this.filter.test(minsn = (MethodInsnNode)insn, values) && !this.seen.contains(minsn) && (result = this.handler.accept(minsn, values)) != null) {
                this.results.add(result);
                this.seen.add(minsn);
            }
            return super.naryOperation(insn, values);
        }
    }
}

