/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.slf4j.Logger;

public class PatchAuditTrailImpl
implements PatchAuditTrail {
    private static final DecimalFormat FORMAT = new DecimalFormat("##.00");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Candidate, AuditLog> auditTrail = new LinkedHashMap<Candidate, AuditLog>();
    private final Map<Candidate, PatchAuditTrail.Match> candidates = new ConcurrentHashMap<Candidate, PatchAuditTrail.Match>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareMethod(MethodContext methodContext) {
        Candidate candidate = new Candidate(methodContext.getMixinClass(), methodContext.getMixinMethod());
        Map<Candidate, AuditLog> map = this.auditTrail;
        synchronized (map) {
            this.auditTrail.put(candidate, AuditLog.create(methodContext));
        }
    }

    @Override
    public void recordAudit(Object transform, ClassNode classNode, String message, Object ... args) {
        Candidate candidate = new Candidate(classNode, null);
        this.recordAudit(transform, null, candidate, message.formatted(args));
    }

    @Override
    public void recordAudit(Object transform, MethodContext methodContext, String message, Object ... args) {
        Candidate candidate = new Candidate(methodContext.getMixinClass(), methodContext.getMixinMethod());
        this.recordAudit(transform, methodContext.getMixinMethod(), candidate, message.formatted(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordAudit(Object transform, @Nullable MethodNode methodNode, Candidate candidate, String message) {
        Map<Candidate, AuditLog> map = this.auditTrail;
        synchronized (map) {
            StringBuilder builder;
            AuditLog auditLog = this.auditTrail.computeIfAbsent(candidate, k -> new AuditLog(methodNode != null ? methodNode.name + methodNode.desc : null, new ArrayList<Pair<Object, StringBuilder>>()));
            List<Pair<Object, StringBuilder>> entries = auditLog.entries();
            if (entries.isEmpty() || entries.getLast().left() != transform) {
                builder = new StringBuilder();
                entries.add((Pair<Object, StringBuilder>)Pair.of((Object)transform, (Object)builder));
                builder.append("\n  >> Using ").append(transform.getClass().getName());
            } else {
                builder = (StringBuilder)entries.getLast().right();
            }
            builder.append("\n     - ").append(message);
            LOGGER.info(PatchInstance.MIXINPATCH, "Applying [{}] {}", (Object)transform.getClass().getSimpleName(), (Object)message);
        }
    }

    @Override
    public void recordResult(MethodContext methodContext, PatchAuditTrail.Match match) {
        Candidate candidate = new Candidate(methodContext.getMixinClass(), methodContext.getMixinMethod());
        this.candidates.compute(candidate, (key, prev) -> prev == null ? match : prev.or(match));
    }

    @Override
    public String getCompleteReport() {
        StringBuilder builder = new StringBuilder();
        this.getSummaryLines().forEach(l -> builder.append((String)l).append("\n"));
        List<Map.Entry> failed = this.candidates.entrySet().stream().filter(m -> m.getValue() == PatchAuditTrail.Match.NONE).toList();
        if (!failed.isEmpty()) {
            builder.append("\n=============== Failed mixins ===============");
            failed.forEach(e -> builder.append("\n").append(((Candidate)e.getKey()).classNode().name).append("\t").append(((Candidate)e.getKey()).methodNode().name).append(((Candidate)e.getKey()).methodNode().desc));
            builder.append("\n=============================================\n\n");
        } else {
            builder.append("\n");
        }
        this.auditTrail.forEach((candidate, auditLog) -> {
            if (auditLog.entries().isEmpty()) {
                return;
            }
            if (auditLog.originalMethod() == null) {
                builder.append("Mixin class ").append(candidate.classNode().name);
            } else {
                builder.append("Mixin method ").append(candidate.classNode().name).append(" ").append(auditLog.originalMethod());
            }
            for (Pair<Object, StringBuilder> record : auditLog.entries()) {
                builder.append((CharSequence)record.right());
            }
            builder.append("\n\n");
        });
        return builder.toString();
    }

    private List<String> getSummaryLines() {
        int total = this.candidates.size();
        int successful = (int)this.candidates.values().stream().filter(m -> m == PatchAuditTrail.Match.FULL).count();
        int partial = (int)this.candidates.values().stream().filter(m -> m == PatchAuditTrail.Match.PARTIAL).count();
        int failed = (int)this.candidates.values().stream().filter(m -> m == PatchAuditTrail.Match.NONE).count();
        double rate = (double)(successful + partial) / (double)total * 100.0;
        double accuracy = ((double)successful / (double)total + (double)partial / (double)total / 2.0) * 100.0;
        return List.of("==== Connector Mixin Patch Audit Summary ====", "Successful: %s".formatted(successful), "Partial: %s".formatted(partial), "Failed: %s".formatted(failed), "Success rate: %s%%        Accuracy: %s%%".formatted(FORMAT.format(rate), FORMAT.format(accuracy)), "=============================================");
    }

    @Override
    public boolean hasFailingMixins() {
        return this.candidates.containsValue((Object)PatchAuditTrail.Match.NONE);
    }

    record Candidate(ClassNode classNode, MethodNode methodNode) {
    }

    record AuditLog(@Nullable String originalMethod, List<Pair<Object, StringBuilder>> entries) {
        public static AuditLog create(MethodContext methodContext) {
            return new AuditLog(methodContext.getMixinMethod().name + methodContext.getMixinMethod().desc, new ArrayList<Pair<Object, StringBuilder>>());
        }
    }
}

