/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl;

import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.metadata.SimplePerson;
import net.neoforged.neoforgespi.language.IModInfo;

public class FMLModMetadata
implements ModMetadata {
    private final IModInfo modInfo;
    private final Version version;
    private final Collection<Person> authors;

    public FMLModMetadata(IModInfo modInfo) {
        this.modInfo = modInfo;
        this.version = (Version)LambdaExceptionUtils.uncheck(() -> Version.parse(this.modInfo.getVersion().toString()));
        this.authors = modInfo.getConfig().getConfigElement(new String[]{"authors"}).stream().flatMap(obj -> {
            Stream<Object> stream;
            if (obj instanceof List) {
                List list = (List)obj;
                stream = list.stream();
            } else {
                stream = Stream.of(obj.toString().split(","));
            }
            return stream;
        }).map(SimplePerson::new).toList();
    }

    @Override
    public String getType() {
        return "fabric";
    }

    @Override
    public String getId() {
        return this.modInfo.getModId();
    }

    @Override
    public Collection<String> getProvides() {
        ArrayList<String> modProvides = new ArrayList<String>(this.modInfo.getConfig().getConfigElement(new String[]{"provides"}).orElseGet(List::of));
        if (modProvides.isEmpty() && this.getId().contains("_")) {
            String normalized = this.getId().replace('_', '-');
            modProvides.add(normalized);
        }
        modProvides.addAll(FabricLoaderImpl.INSTANCE.getModAliases(this.getId()));
        return modProvides;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public ModEnvironment getEnvironment() {
        return ModEnvironment.UNIVERSAL;
    }

    @Override
    public Collection<ModDependency> getDependencies() {
        return Set.of();
    }

    @Override
    public String getName() {
        return this.modInfo.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.modInfo.getDescription();
    }

    @Override
    public Collection<Person> getAuthors() {
        return this.authors;
    }

    @Override
    public Collection<Person> getContributors() {
        return Set.of();
    }

    @Override
    public ContactInformation getContact() {
        return ContactInformation.EMPTY;
    }

    @Override
    public Collection<String> getLicense() {
        return List.of(this.modInfo.getOwningFile().getLicense());
    }

    @Override
    public Optional<String> getIconPath(int size) {
        return this.modInfo.getLogoFile();
    }

    @Override
    public boolean containsCustomValue(String key) {
        return false;
    }

    @Override
    public CustomValue getCustomValue(String key) {
        return null;
    }

    @Override
    public Map<String, CustomValue> getCustomValues() {
        return Map.of();
    }

    @Override
    public boolean containsCustomElement(String key) {
        return false;
    }
}

