/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.CPWorldGen;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LeavingLogReplacer
extends TreeDecorator {
    public static final MapCodec<LeavingLogReplacer> CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)BlockStateProvider.CODEC.fieldOf("replace").forGetter(o -> o.state)).apply((Applicative)t, LeavingLogReplacer::new));
    BlockStateProvider state;

    public LeavingLogReplacer(BlockStateProvider state) {
        this.state = state;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)CPWorldGen.BUSH_PLACER.get();
    }

    public void place(TreeDecorator.Context pContext) {
        HashSet leaves = new HashSet(pContext.leaves());
        for (BlockPos bp : pContext.logs()) {
            boolean n = leaves.contains(bp.north());
            boolean s = leaves.contains(bp.south());
            boolean e = leaves.contains(bp.east());
            boolean w = leaves.contains(bp.west());
            if (!n && !s && !w && !e) continue;
            pContext.setBlock(bp, this.state.getState(pContext.random(), bp));
        }
    }
}

