/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.CPWorldGen;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class FumaroleStructure
extends Structure {
    public static final MapCodec<FumaroleStructure> CODEC = RecordCodecBuilder.mapCodec(p_227640_ -> p_227640_.group((App)FumaroleStructure.settingsCodec((RecordCodecBuilder.Instance)p_227640_), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(p_227656_ -> p_227656_.startPool)).apply((Applicative)p_227640_, FumaroleStructure::new));
    public final Holder<StructureTemplatePool> startPool;

    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext ctx) {
        BlockPos blockpos = ctx.chunkPos().getBlockAt(ctx.random().nextInt(16), 0, ctx.random().nextInt(16));
        int topLandY = ctx.chunkGenerator().getFirstFreeHeight(blockpos.getX(), blockpos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, ctx.heightAccessor(), ctx.randomState());
        blockpos = blockpos.atY(topLandY - 4 + ctx.random().nextInt(1));
        return JigsawPlacement.addPieces((Structure.GenerationContext)ctx, this.startPool, Optional.empty(), (int)32, (BlockPos)blockpos, (boolean)false, Optional.empty(), (int)0, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)JigsawStructure.DEFAULT_DIMENSION_PADDING, (LiquidSettings)JigsawStructure.DEFAULT_LIQUID_SETTINGS);
    }

    public StructureType<?> type() {
        return (StructureType)CPWorldGen.FUMAROLE.get();
    }

    public FumaroleStructure(Structure.StructureSettings p_226558_, Holder<StructureTemplatePool> pool) {
        super(p_226558_);
        this.startPool = pool;
    }
}

