/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.api.events.ContanerContainFoodEvent;
import com.teammoeg.caupona.api.events.EventResult;
import com.teammoeg.caupona.api.events.FoodExchangeItemEvent;
import com.teammoeg.caupona.components.ItemHoldedFluidData;
import com.teammoeg.caupona.components.StewInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.registries.DeferredHolder;

public class Utils {
    public static final Direction[] horizontals = new Direction[]{Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH};
    public static final String FLUID_TAG_KEY = "caupona:fluid";

    private Utils() {
    }

    public static <K, V> Codec<Pair<K, V>> pairCodec(String nkey, Codec<K> key, String nval, Codec<V> val) {
        return RecordCodecBuilder.create(t -> t.group((App)key.fieldOf(nkey).forGetter(Pair::getFirst), (App)val.fieldOf(nval).forGetter(Pair::getSecond)).apply((Applicative)t, Pair::of));
    }

    public static <K, V> Codec<Map<K, V>> mapCodec(Codec<K> keyCodec, Codec<V> valueCodec) {
        return Codec.compoundList(keyCodec, valueCodec).xmap(pl -> pl.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), pl -> pl.entrySet().stream().map(ent -> Pair.of(ent.getKey(), ent.getValue())).toList());
    }

    public static ContanerContainFoodEvent contain(ItemStack its2, FluidStack fs, boolean simulate) {
        ContanerContainFoodEvent ev = new ContanerContainFoodEvent(its2, fs, simulate, false);
        NeoForge.EVENT_BUS.post((Event)ev);
        return ev;
    }

    public static ContanerContainFoodEvent containBlock(ItemStack its2, FluidStack fs) {
        ContanerContainFoodEvent ev = new ContanerContainFoodEvent(its2, fs, false, true);
        NeoForge.EVENT_BUS.post((Event)ev);
        return ev;
    }

    public static FluidStack extractFluid(ItemStack stack) {
        ItemHoldedFluidData si = (ItemHoldedFluidData)stack.get(CPCapability.ITEM_FLUID);
        if (si != null) {
            FluidStack fs = new FluidStack(si.getFluidType(), 250);
            fs.applyComponents(stack.getComponentsPatch());
            fs.remove(CPCapability.ITEM_FLUID);
            return fs;
        }
        return Optional.ofNullable((IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)).map(t -> t.getFluidInTank(0)).orElse(FluidStack.EMPTY);
    }

    public static Fluid getFluidType(ItemStack stack) {
        ItemHoldedFluidData si = (ItemHoldedFluidData)stack.get(CPCapability.ITEM_FLUID);
        if (si != null) {
            return si.getFluidType();
        }
        return Optional.ofNullable((IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)).map(t -> t.getFluidInTank(0).getFluid()).orElse(Fluids.EMPTY);
    }

    public static JsonElement toJson(Ingredient i) {
        return (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)i).result().orElse(JsonNull.INSTANCE);
    }

    public static ItemStack extractOutput(IItemHandler inv, int count) {
        ItemStack is = ItemStack.EMPTY;
        for (int i = 0; i < inv.getSlots() && (is = inv.extractItem(i, count, false)).isEmpty(); ++i) {
        }
        return is;
    }

    public static boolean isExtractAllowed(ItemStack is) {
        FoodExchangeItemEvent.Pre ev = new FoodExchangeItemEvent.Pre(is);
        NeoForge.EVENT_BUS.post((Event)ev);
        return ev.getResult() == EventResult.ALLOW;
    }

    public static boolean isExchangeAllowed(ItemStack or, ItemStack rs) {
        FoodExchangeItemEvent.Post ev = new FoodExchangeItemEvent.Post(or, rs);
        NeoForge.EVENT_BUS.post((Event)ev);
        return ev.getResult() == EventResult.ALLOW;
    }

    public static ItemStack insertToOutput(ItemStackHandler inv, int slot, ItemStack in) {
        ItemStack is = inv.getStackInSlot(slot);
        if (is.isEmpty()) {
            inv.setStackInSlot(slot, in.split(Math.min(inv.getSlotLimit(slot), in.getMaxStackSize())));
        } else if (ItemStack.isSameItemSameComponents((ItemStack)in, (ItemStack)is)) {
            int limit = Math.min(inv.getSlotLimit(slot), is.getMaxStackSize());
            limit -= is.getCount();
            limit = Math.min(limit, in.getCount());
            is.grow(limit);
            in.shrink(limit);
        }
        return in;
    }

    public static void dropToWorld(Level level, ItemStack is, BlockPos pos) {
        if (!is.isEmpty() && !level.isClientSide) {
            ItemEntity entityitem = new ItemEntity(level, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), is);
            entityitem.setPickUpDelay(40);
            entityitem.setDeltaMovement(entityitem.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            level.addFreshEntity((Entity)entityitem);
        }
    }

    public static MutableComponent translate(String format, Object ... objects) {
        return Utils.translateWithFallback(format, null, objects);
    }

    public static MutableComponent translate(String format) {
        return Utils.translate(format, new Object[0]);
    }

    public static MutableComponent translateWithFallback(String format, String fallback, Object ... objects) {
        return MutableComponent.create((ComponentContents)new TranslatableContents(format, fallback, objects));
    }

    public static MutableComponent translateWithFallback(String format, String fallback) {
        return Utils.translate(format, fallback, new Object[0]);
    }

    public static MutableComponent string(String content) {
        return MutableComponent.create((ComponentContents)PlainTextContents.create((String)content));
    }

    public static ResourceLocation getRegistryName(Fluid f) {
        return BuiltInRegistries.FLUID.getKey((Object)f);
    }

    public static ResourceLocation getRegistryName(DeferredHolder<?, ?> r) {
        return r.getId();
    }

    public static ResourceLocation getRegistryName(Item i) {
        return BuiltInRegistries.ITEM.getKey((Object)i);
    }

    public static ResourceLocation getRegistryName(ItemStack i) {
        return Utils.getRegistryName(i.getItem());
    }

    public static ResourceLocation getRegistryName(Block b) {
        return BuiltInRegistries.BLOCK.getKey((Object)b);
    }

    public static ResourceLocation getRegistryName(FluidStack f) {
        return Utils.getRegistryName(f.getFluid());
    }

    public static ResourceLocation getRegistryName(MobEffect effect) {
        return BuiltInRegistries.MOB_EFFECT.getKey((Object)effect);
    }

    public static void addPotionTooltip(List<MobEffectInstance> list, Consumer<Component> lores, float durationFactor, Level pLevel) {
        PotionContents.addPotionTooltip(list, lores, (float)durationFactor, (float)(pLevel == null ? 20.0f : pLevel.tickRateManager().tickrate()));
    }

    public static void writeItemFluid(ItemStack is, Fluid f) {
        is.set(CPCapability.ITEM_FLUID, (Object)new ItemHoldedFluidData(f));
    }

    public static StewInfo getOrCreateInfo(ItemStack stack) {
        StewInfo si = (StewInfo)stack.get(CPCapability.STEW_INFO);
        if (si == null) {
            Fluid type = Utils.getFluidType(stack);
            if (type == Fluids.EMPTY) {
                return new StewInfo();
            }
            return new StewInfo(type);
        }
        return si;
    }

    public static StewInfo getOrCreateInfo(FluidStack stack) {
        StewInfo si = (StewInfo)stack.get(CPCapability.STEW_INFO);
        if (si == null) {
            Fluid type = stack.getFluid();
            if (type == Fluids.EMPTY) {
                return new StewInfo();
            }
            return new StewInfo(type);
        }
        return si;
    }

    public static void setInfo(MutableDataComponentHolder out, StewInfo info) {
        out.set(CPCapability.STEW_INFO, (Object)info);
    }
}

