/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.teammoeg.caupona.network.CPBaseBlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class SyncedFluidHandler
implements IFluidHandler {
    CPBaseBlockEntity block;
    IFluidHandler nested;

    public SyncedFluidHandler(CPBaseBlockEntity block, IFluidHandler nested) {
        this.block = block;
        this.nested = nested;
    }

    public int getTanks() {
        return this.nested.getTanks();
    }

    public FluidStack getFluidInTank(int t) {
        return this.nested.getFluidInTank(t);
    }

    public int getTankCapacity(int t) {
        return this.nested.getTankCapacity(t);
    }

    public boolean isFluidValid(int t, FluidStack stack) {
        return this.nested.isFluidValid(t, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int filled = this.nested.fill(resource, action);
        if (filled != 0 && action.execute()) {
            this.block.syncData();
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = this.nested.drain(resource, action);
        if (!drained.isEmpty() && action.execute()) {
            this.block.syncData();
        }
        return drained;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = this.nested.drain(maxDrain, action);
        if (!drained.isEmpty() && action.execute()) {
            this.block.syncData();
        }
        return drained;
    }
}

