/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.util.SerializeUtil;
import com.teammoeg.caupona.util.Utils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public class SpicedFoodInfo {
    public MobEffectInstance spice;
    public boolean hasSpice = false;
    public ResourceLocation spiceName;

    public SpicedFoodInfo() {
    }

    public SpicedFoodInfo(Optional<MobEffectInstance> spice, Boolean hasSpice, Optional<ResourceLocation> spiceName) {
        this.spice = spice.orElse(null);
        this.hasSpice = hasSpice;
        this.spiceName = spiceName.orElse(null);
    }

    public static <P extends SpicedFoodInfo> Products.P3<RecordCodecBuilder.Mu<P>, Optional<MobEffectInstance>, Boolean, Optional<ResourceLocation>> codecStart(RecordCodecBuilder.Instance<P> i) {
        return i.group((App)SerializeUtil.fromRFBBStreamCodec(MobEffectInstance.STREAM_CODEC, MobEffectInstance.CODEC).optionalFieldOf("spice").forGetter(o -> Optional.ofNullable(o.spice)), (App)Codec.BOOL.fieldOf("hasSpice").forGetter(o -> o.hasSpice), (App)ResourceLocation.CODEC.optionalFieldOf("spiceName").forGetter(o -> Optional.ofNullable(o.spiceName)));
    }

    public static <T extends SpicedFoodInfo> RecordCodecBuilder<T, Optional<MobEffectInstance>> spiceCodec() {
        return MobEffectInstance.CODEC.optionalFieldOf("spice").forGetter(o -> Optional.ofNullable(o.spice));
    }

    public static <T extends SpicedFoodInfo> RecordCodecBuilder<T, Boolean> hasSpiceCodec() {
        return Codec.BOOL.fieldOf("hasSpice").forGetter(o -> o.hasSpice);
    }

    public static <T extends SpicedFoodInfo> RecordCodecBuilder<T, Optional<ResourceLocation>> spiceNameCodec() {
        return ResourceLocation.CODEC.optionalFieldOf("spiceName").forGetter(o -> Optional.ofNullable(o.spiceName));
    }

    public boolean addSpice(MobEffectInstance spice, ItemStack im) {
        if (this.spice != null) {
            return false;
        }
        this.spice = new MobEffectInstance(spice);
        this.hasSpice = true;
        this.spiceName = Utils.getRegistryName(im);
        return true;
    }

    public void clearSpice() {
        this.spice = null;
        this.hasSpice = false;
        this.spiceName = null;
    }

    public boolean canAddSpice() {
        return !this.hasSpice;
    }

    public int hashCode() {
        return Objects.hash(this.hasSpice, this.spice, this.spiceName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpicedFoodInfo other = (SpicedFoodInfo)obj;
        return this.hasSpice == other.hasSpice && Objects.equals(this.spice, other.spice) && Objects.equals(this.spiceName, other.spiceName);
    }
}

