/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.teammoeg.caupona.CPMain;
import com.teammoeg.caupona.util.DataOps;
import com.teammoeg.caupona.util.IRegistryAccessable;
import com.teammoeg.caupona.util.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SerializeUtil {
    private SerializeUtil() {
    }

    public static <T> Optional<T> readOptional(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> func) {
        if (buffer.readBoolean()) {
            return Optional.ofNullable(func.apply(buffer));
        }
        return Optional.empty();
    }

    public static <T> void writeOptional2(FriendlyByteBuf buffer, T data, BiConsumer<FriendlyByteBuf, T> func) {
        SerializeUtil.writeOptional(buffer, data, (T a, FriendlyByteBuf b) -> func.accept((FriendlyByteBuf)b, (Object)a));
    }

    public static <T> void writeOptional(FriendlyByteBuf buffer, T data, BiConsumer<T, FriendlyByteBuf> func) {
        SerializeUtil.writeOptional(buffer, Optional.ofNullable(data), func);
    }

    public static <T> void writeOptional(FriendlyByteBuf buffer, Optional<T> data, BiConsumer<T, FriendlyByteBuf> func) {
        if (data.isPresent()) {
            buffer.writeBoolean(true);
            func.accept(data.get(), buffer);
            return;
        }
        buffer.writeBoolean(false);
    }

    public static <T> List<T> readList(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> func) {
        if (!buffer.readBoolean()) {
            return null;
        }
        int cnt = buffer.readVarInt();
        ArrayList<T> nums = new ArrayList<T>(cnt);
        for (int i = 0; i < cnt; ++i) {
            nums.add(func.apply(buffer));
        }
        return nums;
    }

    public static <T> void writeList(FriendlyByteBuf buffer, Collection<T> elms, BiConsumer<T, FriendlyByteBuf> func) {
        if (elms == null) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        buffer.writeVarInt(elms.size());
        elms.forEach(e -> func.accept(e, buffer));
    }

    public static <T> void writeList2(FriendlyByteBuf buffer, Collection<T> elms, BiConsumer<FriendlyByteBuf, T> func) {
        if (elms == null) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        buffer.writeVarInt(elms.size());
        elms.forEach(e -> func.accept(buffer, e));
    }

    public static <T> List<T> parseJsonList(JsonElement elm, Function<JsonObject, T> mapper) {
        if (elm == null) {
            return Lists.newArrayList();
        }
        if (elm.isJsonArray()) {
            return StreamSupport.stream(elm.getAsJsonArray().spliterator(), false).map(JsonElement::getAsJsonObject).map(mapper).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new Object[]{mapper.apply(elm.getAsJsonObject())});
    }

    public static <T> List<T> parseJsonElmList(JsonElement elm, Function<JsonElement, T> mapper) {
        if (elm == null) {
            return Lists.newArrayList();
        }
        if (elm.isJsonArray()) {
            return StreamSupport.stream(elm.getAsJsonArray().spliterator(), false).map(mapper).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new Object[]{mapper.apply((JsonElement)elm.getAsJsonObject())});
    }

    public static <T> JsonArray toJsonList(Collection<T> li, Function<T, JsonElement> mapper) {
        JsonArray ja = new JsonArray();
        li.stream().map(mapper).forEach(arg_0 -> ((JsonArray)ja).add(arg_0));
        return ja;
    }

    public static <T> ListTag toNBTList(Collection<T> stacks, Function<T, Tag> mapper) {
        ListTag nbt = new ListTag();
        stacks.stream().map(mapper).forEach(arg_0 -> nbt.add(arg_0));
        return nbt;
    }

    public static FluidStack readFluidStack(JsonElement jsonIn) {
        if (jsonIn == null) {
            return null;
        }
        return FluidStack.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonIn).result().map(Pair::getFirst).orElse(FluidStack.EMPTY);
    }

    public static <K, V> void writeMap(FriendlyByteBuf buffer, Map<K, V> elms, BiConsumer<K, FriendlyByteBuf> keywriter, BiConsumer<V, FriendlyByteBuf> valuewriter) {
        SerializeUtil.writeList(buffer, elms.entrySet(), (p, b) -> {
            keywriter.accept(p.getKey(), (FriendlyByteBuf)b);
            valuewriter.accept(p.getValue(), (FriendlyByteBuf)b);
        });
    }

    public static <T extends Enum> StreamCodec<ByteBuf, T> createEnumStreamCodec(T[] values) {
        return ByteBufCodecs.BYTE.map(n -> values[n], v -> (byte)v.ordinal());
    }

    public static <K, V> Map<K, V> readMap(FriendlyByteBuf buffer, Map<K, V> map, Function<FriendlyByteBuf, K> keyreader, Function<FriendlyByteBuf, V> valuereader) {
        map.clear();
        if (!buffer.readBoolean()) {
            return map;
        }
        int cnt = buffer.readVarInt();
        for (int i = 0; i < cnt; ++i) {
            map.put(keyreader.apply(buffer), valuereader.apply(buffer));
        }
        return map;
    }

    public static <T> void writeCodec(RegistryFriendlyByteBuf pb, Codec<T> codec, T obj) {
        DataResult ob = codec.encodeStart(DataOps.COMPRESSED.toRegistryAccessable(pb), obj);
        Optional ret = ob.resultOrPartial(arg_0 -> ((Logger)CPMain.logger).error(arg_0));
        ObjectWriter.writeObject((FriendlyByteBuf)pb, ret.get());
    }

    public static <T> T readCodec(RegistryFriendlyByteBuf pb, Codec<T> codec) {
        DataResult ob = codec.decode(DataOps.COMPRESSED.toRegistryAccessable(pb), ObjectWriter.readObject((FriendlyByteBuf)pb));
        Optional ret = ob.resultOrPartial(arg_0 -> ((Logger)CPMain.logger).error(arg_0));
        return (T)((Pair)ret.get()).getFirst();
    }

    public static <K, V> Map<K, V> readEntry(FriendlyByteBuf buffer, Map<K, V> map, BiConsumer<FriendlyByteBuf, BiConsumer<K, V>> reader) {
        map.clear();
        int cnt = buffer.readVarInt();
        for (int i = 0; i < cnt; ++i) {
            reader.accept(buffer, map::put);
        }
        return map;
    }

    public static <K, V> void writeEntry(FriendlyByteBuf buffer, Map<K, V> elms, BiConsumer<Map.Entry<K, V>, FriendlyByteBuf> func) {
        elms.entrySet().forEach(e -> func.accept((Map.Entry)e, buffer));
    }

    public static <F extends RegistryFriendlyByteBuf, V> StreamCodec<F, V> toStreamCodec(Codec<V> codec) {
        return StreamCodec.of((b, v) -> SerializeUtil.writeCodec(b, codec, v), b -> SerializeUtil.readCodec(b, codec));
    }

    public static <F extends RegistryFriendlyByteBuf, V> StreamCodec<F, V> toStreamCodec(MapCodec<V> codec) {
        return StreamCodec.of((b, v) -> SerializeUtil.writeCodec(b, codec.codec(), v), b -> SerializeUtil.readCodec(b, codec.codec()));
    }

    public static <T> Codec<T> idOrKey(final Registry<T> registry) {
        final Codec byKeyCodec = registry.byNameCodec();
        return new Codec<T>(){

            public <O> DataResult<O> encode(T input, DynamicOps<O> ops, O prefix) {
                if (ops.compressMaps()) {
                    return DataResult.success((Object)ops.createInt(registry.getId(input)));
                }
                return byKeyCodec.encode(input, ops, prefix);
            }

            public <O> DataResult<Pair<T, O>> decode(DynamicOps<O> ops, O input) {
                if (ops.compressMaps()) {
                    return ops.getNumberValue(input).map(p -> Pair.of((Object)registry.byId(p.intValue()), (Object)input));
                }
                return byKeyCodec.decode(ops, input);
            }

            public String toString() {
                return "IdOrKeyCodec[registry=" + String.valueOf(registry) + "]";
            }
        };
    }

    public static <T> Codec<T> fromRFBBStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, T> codec, final @NonNull Codec<T> defaultCodec) {
        return new Codec<T>(){

            public <O> DataResult<O> encode(T input, DynamicOps<O> ops, O prefix) {
                if (ops.compressMaps() && ops instanceof IRegistryAccessable) {
                    IRegistryAccessable ra = (IRegistryAccessable)ops;
                    ByteBuf data = Unpooled.buffer((int)512);
                    codec.mapStream(ra.decorator()).encode((Object)data, input);
                    return DataResult.success((Object)ops.createByteList(data.nioBuffer()));
                }
                return defaultCodec.encode(input, ops, prefix);
            }

            public <O> DataResult<Pair<T, O>> decode(DynamicOps<O> ops, O input) {
                if (ops.compressMaps() && ops instanceof IRegistryAccessable) {
                    IRegistryAccessable ra = (IRegistryAccessable)ops;
                    return ops.getByteBuffer(input).map(Unpooled::wrappedBuffer).map(o -> Pair.of((Object)codec.mapStream(ra.decorator()).decode(o), (Object)input));
                }
                return defaultCodec.decode(ops, input);
            }

            public String toString() {
                return "StreamCodecCodec[registry=" + String.valueOf(codec) + "]";
            }
        };
    }

    public static <T> Codec<T> fromFBBStreamCodec(StreamCodec<FriendlyByteBuf, T> codec, @Nullable Codec<T> defaultCodec) {
        return SerializeUtil.fromStreamCodec(codec.mapStream(FriendlyByteBuf::new), defaultCodec);
    }

    public static <T> Codec<T> fromStreamCodec(final StreamCodec<ByteBuf, T> codec, final @Nullable Codec<T> defaultCodec) {
        return new Codec<T>(){

            public <O> DataResult<O> encode(T input, DynamicOps<O> ops, O prefix) {
                if (ops.compressMaps() || defaultCodec == null) {
                    ByteBuf data = Unpooled.buffer((int)512);
                    codec.encode((Object)data, input);
                    return DataResult.success((Object)ops.createByteList(data.nioBuffer()));
                }
                return defaultCodec.encode(input, ops, prefix);
            }

            public <O> DataResult<Pair<T, O>> decode(DynamicOps<O> ops, O input) {
                if (ops.compressMaps() || defaultCodec == null) {
                    return ops.getByteBuffer(input).map(Unpooled::wrappedBuffer).map(o -> Pair.of((Object)codec.decode(o), (Object)input));
                }
                return defaultCodec.decode(ops, input);
            }

            public String toString() {
                return "StreamCodecCodec[registry=" + String.valueOf(codec) + "]";
            }
        };
    }
}

