/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.teammoeg.caupona.util.DataOps;
import com.teammoeg.caupona.util.SerializeUtil;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;

public class ObjectWriter {
    public static TypedValue getTyped(Object input) {
        if (input instanceof Byte) {
            return new TypedValue(1, input);
        }
        if (input instanceof Short) {
            return new TypedValue(2, input);
        }
        if (input instanceof Integer) {
            return new TypedValue(3, input);
        }
        if (input instanceof Long) {
            return new TypedValue(4, input);
        }
        if (input instanceof Float) {
            return new TypedValue(5, input);
        }
        if (input instanceof Double) {
            return new TypedValue(6, input);
        }
        if (input instanceof String) {
            return new TypedValue(7, input);
        }
        if (input instanceof Map) {
            return new TypedValue(8, input);
        }
        if (input instanceof List) {
            Class<?> cls = DataOps.getElmClass((List)input);
            if (cls == Byte.class) {
                return new TypedValue(9, input);
            }
            if (cls == Integer.class) {
                return new TypedValue(10, input);
            }
            if (cls == Long.class) {
                return new TypedValue(11, input);
            }
            if (cls == String.class) {
                return new TypedValue(12, input);
            }
            if (cls == Map.class) {
                return new TypedValue(13, input);
            }
            if (((List)input).isEmpty()) {
                return new TypedValue(15, input);
            }
            return new TypedValue(14, input);
        }
        return new TypedValue(0, input);
    }

    public static void writeTyped(FriendlyByteBuf pb, TypedValue input) {
        switch (input.type) {
            case 1: {
                pb.writeByte(((Byte)input.value).byteValue());
                break;
            }
            case 2: {
                pb.writeShort((int)((Short)input.value).shortValue());
                break;
            }
            case 3: {
                pb.writeVarInt(((Integer)input.value).intValue());
                break;
            }
            case 4: {
                pb.writeVarLong(((Long)input.value).longValue());
                break;
            }
            case 5: {
                pb.writeFloat(((Float)input.value).floatValue());
                break;
            }
            case 6: {
                pb.writeDouble(((Double)input.value).doubleValue());
                break;
            }
            case 7: {
                pb.writeUtf((String)input.value);
                break;
            }
            case 8: {
                SerializeUtil.writeEntry(pb, (Map)input.value, (t, p) -> {
                    TypedValue key = ObjectWriter.getTyped(t.getKey());
                    TypedValue value = ObjectWriter.getTyped(t.getValue());
                    pb.writeByte((key.type << 4) + value.type);
                    ObjectWriter.writeTyped(pb, key);
                    ObjectWriter.writeTyped(pb, value);
                });
                break;
            }
            case 9: {
                byte[] bs = (byte[])DataOps.INSTANCE.getByteArray(input.value).result().get();
                pb.writeByteArray(bs);
                break;
            }
            case 10: {
                SerializeUtil.writeList(pb, (List)input.value, (t, p) -> p.writeVarInt(t.intValue()));
                break;
            }
            case 11: {
                SerializeUtil.writeList(pb, (List)input.value, (t, p) -> p.writeLong(t.longValue()));
                break;
            }
            case 12: {
                SerializeUtil.writeList(pb, (List)input.value, (t, p) -> p.writeUtf(t));
                break;
            }
            case 13: {
                SerializeUtil.writeList(pb, (List)input.value, (t, p) -> ObjectWriter.writeTyped(p, new TypedValue(8, t)));
                break;
            }
            case 14: {
                List obj = (List)input.value;
                List<TypedValue> typed = obj.stream().map(o -> ObjectWriter.getTyped(o)).collect(Collectors.toList());
                pb.writeVarInt(typed.size());
                if (typed.size() % 2 == 1) {
                    typed.add(new TypedValue(0));
                }
                for (int i = 0; i < typed.size() / 2; ++i) {
                    pb.writeByte((((TypedValue)typed.get((int)(i * 2))).type << 4) + ((TypedValue)typed.get((int)(i * 2 + 1))).type);
                }
                typed.forEach(t -> ObjectWriter.writeTyped(pb, t));
            }
        }
    }

    public static Object readWithType(int type, FriendlyByteBuf pb) {
        switch (type) {
            case 1: {
                return pb.readByte();
            }
            case 2: {
                return pb.readShort();
            }
            case 3: {
                return pb.readVarInt();
            }
            case 4: {
                return pb.readVarLong();
            }
            case 5: {
                return Float.valueOf(pb.readFloat());
            }
            case 6: {
                return pb.readDouble();
            }
            case 7: {
                return pb.readUtf();
            }
            case 8: {
                return SerializeUtil.readEntry(pb, new HashMap(), (p, c) -> {
                    byte byt = pb.readByte();
                    Object key = ObjectWriter.readWithType(byt >> 4 & 0xF, pb);
                    Object value = ObjectWriter.readWithType(byt & 0xF, pb);
                    c.accept(key, value);
                });
            }
            case 9: {
                return DataOps.INSTANCE.createByteList(ByteBuffer.wrap(pb.readByteArray()));
            }
            case 10: {
                return SerializeUtil.readList(pb, FriendlyByteBuf::readVarInt);
            }
            case 11: {
                return SerializeUtil.readList(pb, FriendlyByteBuf::readLong);
            }
            case 12: {
                return SerializeUtil.readList(pb, FriendlyByteBuf::readUtf);
            }
            case 13: {
                return SerializeUtil.readList(pb, p -> ObjectWriter.readWithType(8, p));
            }
            case 14: {
                ArrayList<Object> obj = new ArrayList<Object>();
                int size = pb.readVarInt();
                ByteBuf crnbytes = pb.readBytes((size + 1) / 2);
                for (int i = 0; i < size; ++i) {
                    if (i % 2 == 1) {
                        obj.add(ObjectWriter.readWithType(crnbytes.getByte(i / 2) & 0xF, pb));
                        continue;
                    }
                    obj.add(ObjectWriter.readWithType(crnbytes.getByte(i / 2) >> 4 & 0xF, pb));
                }
                return obj;
            }
            case 15: {
                return new ArrayList();
            }
        }
        return null;
    }

    public static void writeObject(FriendlyByteBuf pb, Object input) {
        TypedValue value = ObjectWriter.getTyped(input);
        pb.writeByte(value.type);
        ObjectWriter.writeTyped(pb, value);
    }

    public static Object readObject(FriendlyByteBuf pb) {
        Object out = ObjectWriter.readWithType(pb.readByte(), pb);
        return out;
    }

    private static class TypedValue {
        int type;
        Object value;

        public TypedValue(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        public TypedValue(int type) {
            this.type = type;
            this.value = DataOps.NULLTAG;
        }
    }
}

