/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.teammoeg.caupona.api.events.ContanerContainFoodEvent;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidItemWrapper
implements IFluidHandlerItem {
    protected ItemStack container;

    public FluidItemWrapper(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public FluidStack getFluid() {
        return Utils.extractFluid(this.container);
    }

    protected void setFluid(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            this.container = this.container.getCraftingRemainingItem();
            return;
        }
        ContanerContainFoodEvent ev = Utils.contain(this.container.getCraftingRemainingItem(), fluidStack, false);
        if (ev.isAllowed()) {
            this.container = ev.out;
        }
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 250) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && fluidStack.isFluidEqual(resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public int getTanks() {
        return 1;
    }

    public int getTankCapacity(int tank) {
        return 250;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || maxDrain < 250) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

