/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.util.SerializeUtil;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.Nullable;

public class FloatemStack {
    private final ItemStack stack;
    public float count;
    public static final Codec<FloatemStack> CODEC = RecordCodecBuilder.create(o -> o.group((App)SerializeUtil.fromRFBBStreamCodec(ItemStack.STREAM_CODEC, ItemStack.CODEC).fieldOf("item").forGetter(i -> i.stack), (App)Codec.FLOAT.fieldOf("count").forGetter(i -> Float.valueOf(i.count))).apply((Applicative)o, FloatemStack::new));

    public FloatemStack(ItemStack stack, float count) {
        this.stack = stack.copy();
        this.stack.setCount(1);
        this.count = count;
    }

    public FloatemStack(ItemStack is) {
        this(is, is.getCount());
    }

    public ItemStack getStack() {
        return this.stack.copy();
    }

    public boolean isEmpty() {
        return (double)this.count <= 0.001;
    }

    public Item getItem() {
        return this.stack.getItem();
    }

    public int getMaxStackSize() {
        return this.stack.getMaxStackSize();
    }

    public boolean isStackable() {
        return this.stack.isStackable();
    }

    public boolean isDamageable() {
        return this.stack.isDamageableItem();
    }

    public FloatemStack copy() {
        return new FloatemStack(this.stack.copy(), this.count);
    }

    public FloatemStack copyWithCount(float count) {
        return new FloatemStack(this.stack.copy(), count);
    }

    public boolean isItemEqual(ItemStack other) {
        return ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)other);
    }

    public String getTranslationKey() {
        return this.stack.getDescriptionId();
    }

    public Stream<ResourceLocation> getTags() {
        return this.stack.getTags().map(TagKey::location);
    }

    public Component getDisplayName() {
        return this.stack.getHoverName();
    }

    public Rarity getRarity() {
        return this.stack.getRarity();
    }

    public Component getTextComponent() {
        return this.stack.getDisplayName();
    }

    public float getCount() {
        return this.count;
    }

    public void setCount(float count) {
        this.count = count;
    }

    public void grow(float count) {
        this.count += count;
    }

    public void shrink(float count) {
        this.count -= count;
        if (this.count < 0.0f) {
            this.count = 0.0f;
        }
    }

    public boolean equals(ItemStack other) {
        return ItemStack.isSameItemSameComponents((ItemStack)this.getStack(), (ItemStack)other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.count);
        result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatemStack other = (FloatemStack)obj;
        if (Float.floatToIntBits(this.count) != Float.floatToIntBits(other.count)) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !this.equals(other.stack));
    }

    public <T> T get(DataComponentType<? extends T> component) {
        return (T)this.stack.get(component);
    }

    @Nullable
    public <T> T get(Supplier<? extends DataComponentType<? extends T>> type) {
        return (T)this.stack.get(type);
    }

    @Nullable
    public <T> T set(Supplier<? extends DataComponentType<? super T>> componentType, @Nullable T value) {
        return (T)this.stack.set(componentType, value);
    }

    @Nullable
    public <T, U> T update(Supplier<? extends DataComponentType<T>> componentType, T value, U updateContext, BiFunction<T, U, T> updater) {
        return (T)this.stack.update(componentType, value, updateContext, updater);
    }

    @Nullable
    public <T> T update(Supplier<? extends DataComponentType<T>> componentType, T value, UnaryOperator<T> updater) {
        return (T)this.stack.update(componentType, value, updater);
    }

    public void copyFrom(DataComponentHolder src, DataComponentType<?> ... componentTypes) {
        this.stack.copyFrom(src, componentTypes);
    }

    public void copyFrom(DataComponentHolder src, Supplier<? extends DataComponentType<?>> ... componentTypes) {
        this.stack.copyFrom(src, (Supplier[])componentTypes);
    }

    public <T> T set(DataComponentType<? super T> component, T value) {
        return (T)this.stack.set(component, value);
    }

    public <T, U> T update(DataComponentType<T> component, T defaultValue, U updateValue, BiFunction<T, U, T> updater) {
        return (T)this.stack.update(component, defaultValue, updateValue, updater);
    }

    public <T> T update(DataComponentType<T> component, T defaultValue, UnaryOperator<T> updater) {
        return (T)this.stack.update(component, defaultValue, updater);
    }
}

