/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.teammoeg.caupona.util.IRegistryAccessable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.neoforge.network.connection.ConnectionType;

public class DataOps
implements DynamicOps<Object> {
    public static final DataOps INSTANCE = new DataOps(false);
    public static final DataOps COMPRESSED = new DataOps(true);
    public static final Object NULLTAG = new Object(){

        public String toString() {
            return "nulltag";
        }
    };
    boolean compress;

    public DynamicOps<Object> toRegistryAccessable(RegistryFriendlyByteBuf buf) {
        return new RegisterFriendlyDataOps(this, buf);
    }

    public static Class<?> getElmClass(List<Object> objs) {
        if (!objs.isEmpty()) {
            if (objs.get(0) == null) {
                return null;
            }
            Class<?> cls = objs.get(0).getClass();
            for (Object obj : objs) {
                if (cls.isInstance(obj)) continue;
                return null;
            }
            return cls;
        }
        return null;
    }

    public DataOps(boolean compress) {
        this.compress = compress;
    }

    private static <T> DataResult<T> cast(Class<T> type, Object input) {
        if (type.isInstance(input)) {
            return DataResult.success((Object)input);
        }
        return DataResult.error(() -> "Not a " + type.getSimpleName());
    }

    private static DataResult<Map<Object, Object>> castToMap(Object input) {
        if (input instanceof Map) {
            return DataResult.success((Object)((Map)input));
        }
        return DataResult.error(() -> "Not a Map");
    }

    private static DataResult<List<Object>> castToList(Object input) {
        if (input instanceof List) {
            return DataResult.success((Object)((List)input));
        }
        return DataResult.error(() -> "Not a List");
    }

    public boolean compressMaps() {
        return this.compress;
    }

    public <U> U convertTo(DynamicOps<U> outOps, Object input) {
        if (input instanceof Byte) {
            return (U)outOps.createByte(((Byte)input).byteValue());
        }
        if (input instanceof Short) {
            return (U)outOps.createShort(((Short)input).shortValue());
        }
        if (input instanceof Integer) {
            return (U)outOps.createInt(((Integer)input).intValue());
        }
        if (input instanceof Long) {
            return (U)outOps.createLong(((Long)input).longValue());
        }
        if (input instanceof Float) {
            return (U)outOps.createFloat(((Float)input).floatValue());
        }
        if (input instanceof Double) {
            return (U)outOps.createDouble(((Double)input).doubleValue());
        }
        if (input instanceof String) {
            return (U)outOps.createString((String)input);
        }
        if (input instanceof Map) {
            return (U)outOps.createMap(((Map)input).entrySet().stream().map(o -> Pair.of(this.convertTo(outOps, o.getKey()), this.convertTo(outOps, o.getValue()))));
        }
        if (input instanceof List) {
            List objs = (List)input;
            Class<?> cls = DataOps.getElmClass(objs);
            if (cls == Byte.class) {
                return (U)outOps.createByteList((ByteBuffer)this.getByteBuffer(objs).result().get());
            }
            if (cls == Integer.class) {
                return (U)outOps.createIntList((IntStream)this.getIntStream(objs).result().get());
            }
            if (cls == Long.class) {
                return (U)outOps.createLongList((LongStream)this.getLongStream(objs).result().get());
            }
            return (U)outOps.createList(objs.stream().map(o -> this.convertTo(outOps, o)));
        }
        return (U)outOps.empty();
    }

    public Object createList(Stream<Object> input) {
        return input.collect(Collectors.toList());
    }

    public Object createMap(Map<Object, Object> map) {
        return new HashMap<Object, Object>(map);
    }

    public Object createMap(Stream<Pair<Object, Object>> map) {
        return map.collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public Object createNumeric(Number i) {
        return i;
    }

    public Object createString(String value) {
        return value;
    }

    public Object empty() {
        return NULLTAG;
    }

    public Object emptyList() {
        return new ArrayList();
    }

    public Object emptyMap() {
        return new HashMap();
    }

    public DataResult<byte[]> getByteArray(Object input) {
        DataResult<List<Object>> dr = DataOps.castToList(input);
        if (dr.result().isPresent()) {
            List res = (List)dr.result().get();
            if (res.isEmpty()) {
                return DataResult.success((Object)new byte[0]);
            }
            if (DataOps.getElmClass(res) == Byte.class) {
                int siz = res.size();
                byte[] bs = new byte[siz];
                for (int i = 0; i < siz; ++i) {
                    bs[i] = (Byte)res.get(i);
                }
                return DataResult.success((Object)bs);
            }
        }
        return DataResult.error(() -> "Not a byte array");
    }

    public DataResult<ByteBuffer> getByteBuffer(Object input) {
        return this.getByteArray(input).map(ByteBuffer::wrap);
    }

    public DataResult<int[]> getIntArray(Object input) {
        DataResult<List<Object>> dr = DataOps.castToList(input);
        if (dr.result().isPresent()) {
            List res = (List)dr.result().get();
            if (res.isEmpty()) {
                return DataResult.success((Object)new int[0]);
            }
            if (DataOps.getElmClass(res) == Integer.class) {
                int siz = res.size();
                int[] bs = new int[siz];
                for (int i = 0; i < siz; ++i) {
                    bs[i] = (Integer)res.get(i);
                }
                return DataResult.success((Object)bs);
            }
        }
        return DataResult.error(() -> "Not a int array");
    }

    public DataResult<IntStream> getIntStream(Object input) {
        return this.getIntArray(input).map(IntStream::of);
    }

    public DataResult<Consumer<Consumer<Object>>> getList(Object input) {
        return DataOps.castToList(input).map(t -> t::forEach);
    }

    public DataResult<long[]> getLongArray(Object input) {
        DataResult<List<Object>> dr = DataOps.castToList(input);
        if (dr.result().isPresent()) {
            List res = (List)dr.result().get();
            if (res.isEmpty()) {
                return DataResult.success((Object)new long[0]);
            }
            if (DataOps.getElmClass(res) == Long.class) {
                int siz = res.size();
                long[] bs = new long[siz];
                for (int i = 0; i < siz; ++i) {
                    bs[i] = (Long)res.get(i);
                }
                return DataResult.success((Object)bs);
            }
        }
        return DataResult.error(() -> "Not a long array");
    }

    public DataResult<LongStream> getLongStream(Object input) {
        return this.getLongArray(input).map(LongStream::of);
    }

    public DataResult<MapLike<Object>> getMap(Object input) {
        return DataOps.castToMap(input).map(o -> new MLike((Map<Object, Object>)o));
    }

    public DataResult<Consumer<BiConsumer<Object, Object>>> getMapEntries(Object input) {
        return DataOps.castToMap(input).map(s -> c -> s.entrySet().forEach(p -> c.accept(p.getKey(), p.getValue())));
    }

    public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
        return DataOps.castToMap(input).map(t -> t.entrySet().stream().map(o -> Pair.of(o.getKey(), o.getValue())));
    }

    public DataResult<Number> getNumberValue(Object input) {
        return DataOps.cast(Number.class, input);
    }

    public Number getNumberValue(Object input, Number defaultValue) {
        return DataOps.cast(Number.class, input).result().orElse(defaultValue);
    }

    public DataResult<Stream<Object>> getStream(Object input) {
        return DataOps.castToList(input).map(t -> t.stream());
    }

    public DataResult<String> getStringValue(Object input) {
        return DataOps.cast(String.class, input);
    }

    public ListBuilder<Object> listBuilder() {
        return new LBuilder(this);
    }

    public RecordBuilder<Object> mapBuilder() {
        return new MBuilder(this);
    }

    public DataResult<Object> mergeToList(Object list, List<Object> values) {
        if (list instanceof List) {
            List li = (List)list;
            li.addAll(values);
        } else if (list == NULLTAG || list == null) {
            return DataResult.success(values);
        }
        return DataResult.error(() -> "Not a Map or Empty");
    }

    public DataResult<Object> mergeToList(Object list, Object value) {
        if (list == NULLTAG || list == null) {
            return DataResult.success(Stream.of(value).collect(Collectors.toList()));
        }
        DataResult<List<Object>> ret = DataOps.castToList(list);
        ret.result().ifPresent(t -> t.add(value));
        return ret;
    }

    public DataResult<Object> mergeToMap(Object map, Map<Object, Object> values) {
        if (map instanceof Map) {
            Map li = (Map)map;
            li.putAll(values);
        } else if (map == NULLTAG || map == null) {
            return DataResult.success(values);
        }
        return DataResult.error(() -> "Not a Map or Empty");
    }

    public DataResult<Object> mergeToMap(Object map, MapLike<Object> values) {
        if (values instanceof MLike) {
            return this.mergeToMap(map, ((MLike)values).map);
        }
        return super.mergeToMap(map, values);
    }

    public DataResult<Object> mergeToMap(Object map, Object key, Object value) {
        if (map == NULLTAG || map == null) {
            return DataResult.success(Stream.of(Pair.of((Object)key, (Object)value)).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }
        DataResult<Map<Object, Object>> ret = DataOps.castToMap(map);
        ret.result().ifPresent(t -> t.put(key, value));
        return ret;
    }

    public DataResult<Object> mergeToPrimitive(Object prefix, Object value) {
        if (prefix != NULLTAG && prefix != null) {
            return DataResult.error(() -> "Do not know how to append a primitive value " + String.valueOf(value) + " to " + String.valueOf(prefix), (Object)value);
        }
        return DataResult.success((Object)value);
    }

    public Object remove(Object input, String key) {
        return DataOps.castToMap(input).result().map(t -> t.remove(key)).orElse(NULLTAG);
    }

    public <U> U convertMap(DynamicOps<U> outOps, Object input) {
        return (U)outOps.createMap(((Map)DataOps.castToMap(input).result().orElse(ImmutableMap.of())).entrySet().stream().map(t -> Pair.of(this.convertTo(outOps, t.getKey()), this.convertTo(outOps, t.getValue()))));
    }

    public DataResult<Object> get(Object input, String key) {
        return this.getGeneric(input, key);
    }

    public DataResult<Object> getGeneric(Object input, Object key) {
        return DataOps.castToMap(input).flatMap(t -> {
            Object value = t.get(key);
            return value == null ? DataResult.error(() -> "No value for " + String.valueOf(key) + " present") : DataResult.success(value);
        });
    }

    public Object set(Object input, String key, Object value) {
        return this.mergeToMap(input, key, value).result().orElse(input);
    }

    public Object update(Object input, String key, Function<Object, Object> function) {
        DataResult<Map<Object, Object>> ret = DataOps.castToMap(input);
        ret.result().ifPresent(t -> t.compute(key, (k, v) -> function.apply(v == null ? NULLTAG : v)));
        return ret;
    }

    public Object updateGeneric(Object input, Object key, Function<Object, Object> function) {
        DataResult<Map<Object, Object>> ret = DataOps.castToMap(input);
        ret.result().ifPresent(t -> t.compute(key, (k, v) -> function.apply(v == null ? NULLTAG : v)));
        return ret;
    }

    public String toString() {
        return "Data" + (this.compress ? "Compressed" : "");
    }

    public Object createByteList(ByteBuffer input) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (int i = 0; i < input.capacity(); ++i) {
            list.add(input.get(i));
        }
        return list;
    }

    public Object createIntList(IntStream input) {
        return input.boxed().collect(Collectors.toList());
    }

    public Object createLongList(LongStream input) {
        return input.boxed().collect(Collectors.toList());
    }

    public <U> U convertList(DynamicOps<U> outOps, Object input) {
        DataResult<List<Object>> result = DataOps.castToList(input);
        if (!result.result().isPresent()) {
            return (U)outOps.emptyList();
        }
        List list = (List)result.result().get();
        Class<?> clazz = DataOps.getElmClass(list);
        if (clazz == Byte.class) {
            ByteBuffer bb = ByteBuffer.allocate(list.size());
            list.stream().forEach(b -> bb.put((Byte)b));
            return (U)outOps.createByteList(bb);
        }
        if (clazz == Integer.class) {
            return (U)outOps.createIntList(list.stream().mapToInt(t -> (Integer)t));
        }
        if (clazz == Long.class) {
            return (U)outOps.createLongList(list.stream().mapToLong(t -> (Long)t));
        }
        return (U)outOps.createList(list.stream().map(t -> this.convertList(outOps, t)));
    }

    public record RegisterFriendlyDataOps(DataOps op, RegistryAccess registryAccess, ConnectionType connectionType) implements DynamicOps<Object>,
    IRegistryAccessable
    {
        public RegisterFriendlyDataOps(DataOps op, RegistryFriendlyByteBuf buf) {
            this(op, buf.registryAccess(), buf.getConnectionType());
        }

        public Object createByte(byte value) {
            return this.op.createByte(value);
        }

        public Object createShort(short value) {
            return this.op.createShort(value);
        }

        public Object createInt(int value) {
            return this.op.createInt(value);
        }

        public Object createLong(long value) {
            return this.op.createLong(value);
        }

        public Object createFloat(float value) {
            return this.op.createFloat(value);
        }

        @Override
        public int hashCode() {
            return this.op.hashCode();
        }

        public Object createDouble(double value) {
            return this.op.createDouble(value);
        }

        public DataResult<Boolean> getBooleanValue(Object input) {
            return this.op.getBooleanValue(input);
        }

        public Object createBoolean(boolean value) {
            return this.op.createBoolean(value);
        }

        @Override
        public boolean equals(Object obj) {
            return this.op.equals(obj);
        }

        public boolean compressMaps() {
            return this.op.compressMaps();
        }

        public <U> U convertTo(DynamicOps<U> outOps, Object input) {
            return this.op.convertTo(outOps, input);
        }

        public Object createList(Stream<Object> input) {
            return this.op.createList(input);
        }

        public Object createMap(Map<Object, Object> map) {
            return this.op.createMap(map);
        }

        public Object createMap(Stream<Pair<Object, Object>> map) {
            return this.op.createMap(map);
        }

        public Object createNumeric(Number i) {
            return this.op.createNumeric(i);
        }

        public Object createString(String value) {
            return this.op.createString(value);
        }

        public Object empty() {
            return this.op.empty();
        }

        public Object emptyList() {
            return this.op.emptyList();
        }

        public <E> Function<E, DataResult<Object>> withEncoder(Encoder<E> encoder) {
            return this.op.withEncoder(encoder);
        }

        public Object emptyMap() {
            return this.op.emptyMap();
        }

        public DataResult<byte[]> getByteArray(Object input) {
            return this.op.getByteArray(input);
        }

        public <E> Function<Object, DataResult<Pair<E, Object>>> withDecoder(Decoder<E> decoder) {
            return this.op.withDecoder(decoder);
        }

        public <E> Function<Object, DataResult<E>> withParser(Decoder<E> decoder) {
            return this.op.withParser(decoder);
        }

        public DataResult<ByteBuffer> getByteBuffer(Object input) {
            return this.op.getByteBuffer(input);
        }

        public DataResult<int[]> getIntArray(Object input) {
            return this.op.getIntArray(input);
        }

        public DataResult<IntStream> getIntStream(Object input) {
            return this.op.getIntStream(input);
        }

        public DataResult<Consumer<Consumer<Object>>> getList(Object input) {
            return this.op.getList(input);
        }

        public DataResult<long[]> getLongArray(Object input) {
            return this.op.getLongArray(input);
        }

        public DataResult<LongStream> getLongStream(Object input) {
            return this.op.getLongStream(input);
        }

        public DataResult<MapLike<Object>> getMap(Object input) {
            return this.op.getMap(input);
        }

        public DataResult<Consumer<BiConsumer<Object, Object>>> getMapEntries(Object input) {
            return this.op.getMapEntries(input);
        }

        public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
            return this.op.getMapValues(input);
        }

        public DataResult<Number> getNumberValue(Object input) {
            return this.op.getNumberValue(input);
        }

        public Number getNumberValue(Object input, Number defaultValue) {
            return this.op.getNumberValue(input, defaultValue);
        }

        public DataResult<Stream<Object>> getStream(Object input) {
            return this.op.getStream(input);
        }

        public DataResult<String> getStringValue(Object input) {
            return this.op.getStringValue(input);
        }

        public ListBuilder<Object> listBuilder() {
            return this.op.listBuilder();
        }

        public RecordBuilder<Object> mapBuilder() {
            return this.op.mapBuilder();
        }

        public DataResult<Object> mergeToList(Object list, List<Object> values) {
            return this.op.mergeToList(list, values);
        }

        public DataResult<Object> mergeToList(Object list, Object value) {
            return this.op.mergeToList(list, value);
        }

        public DataResult<Object> mergeToMap(Object map, Map<Object, Object> values) {
            return this.op.mergeToMap(map, values);
        }

        public DataResult<Object> mergeToMap(Object map, MapLike<Object> values) {
            return this.op.mergeToMap(map, values);
        }

        public DataResult<Object> mergeToMap(Object map, Object key, Object value) {
            return this.op.mergeToMap(map, key, value);
        }

        public DataResult<Object> mergeToPrimitive(Object prefix, Object value) {
            return this.op.mergeToPrimitive(prefix, value);
        }

        public Object remove(Object input, String key) {
            return this.op.remove(input, key);
        }

        public <U> U convertMap(DynamicOps<U> outOps, Object input) {
            return this.op.convertMap(outOps, input);
        }

        public DataResult<Object> get(Object input, String key) {
            return this.op.get(input, key);
        }

        public DataResult<Object> getGeneric(Object input, Object key) {
            return this.op.getGeneric(input, key);
        }

        public Object set(Object input, String key, Object value) {
            return this.op.set(input, key, value);
        }

        public Object update(Object input, String key, Function<Object, Object> function) {
            return this.op.update(input, key, function);
        }

        public Object updateGeneric(Object input, Object key, Function<Object, Object> function) {
            return this.op.updateGeneric(input, key, function);
        }

        @Override
        public String toString() {
            return this.op.toString();
        }

        public Object createByteList(ByteBuffer input) {
            return this.op.createByteList(input);
        }

        public Object createIntList(IntStream input) {
            return this.op.createIntList(input);
        }

        public Object createLongList(LongStream input) {
            return this.op.createLongList(input);
        }

        public <U> U convertList(DynamicOps<U> outOps, Object input) {
            return this.op.convertList(outOps, input);
        }
    }

    private static class LBuilder
    implements ListBuilder<Object> {
        private DataResult<List<Object>> list = DataResult.success(new ArrayList());
        DataOps ops;

        public LBuilder(DataOps ops) {
            this.ops = ops;
        }

        public LBuilder add(DataResult<Object> value) {
            this.list.apply2stable(List::add, value);
            return this;
        }

        public LBuilder add(Object value) {
            this.list.map(t -> t.add(value));
            return this;
        }

        public DataResult<Object> build(Object prefix) {
            DataResult result = this.list.flatMap(b -> this.ops.mergeToList(prefix, (List<Object>)b));
            this.list = DataResult.success(new ArrayList(), (Lifecycle)Lifecycle.stable());
            return result;
        }

        public LBuilder mapError(UnaryOperator<String> onError) {
            this.list = this.list.mapError(onError);
            return this;
        }

        public DataOps ops() {
            return this.ops;
        }

        public LBuilder withErrorsFrom(DataResult<?> result) {
            this.list = this.list.flatMap(r -> result.map(v -> r));
            return this;
        }
    }

    private static class MBuilder
    implements RecordBuilder<Object> {
        DataOps ops;
        DataResult<Map<Object, Object>> map;

        public MBuilder(DataOps ops) {
            this.ops = ops;
            this.map = DataResult.success(new HashMap());
        }

        public MBuilder add(DataResult<Object> key, DataResult<Object> value) {
            this.map.ap(key.apply2stable((k, v) -> b -> b.put(k, v), value));
            return this;
        }

        public MBuilder add(Object key, DataResult<Object> value) {
            this.map.apply2stable((o, r) -> o.put(key, r), value);
            return this;
        }

        public MBuilder add(Object key, Object value) {
            this.map.map(o -> o.put(key, value));
            return this;
        }

        public DataResult<Object> build(Object prefix) {
            DataResult result = this.map.flatMap(b -> this.ops.mergeToMap(prefix, (Map<Object, Object>)b));
            this.map = DataResult.success(new HashMap(), (Lifecycle)Lifecycle.stable());
            return result;
        }

        public MBuilder mapError(UnaryOperator<String> onError) {
            this.map = this.map.mapError(onError);
            return this;
        }

        public DynamicOps<Object> ops() {
            return this.ops;
        }

        public MBuilder setLifecycle(Lifecycle lifecycle) {
            this.map = this.map.setLifecycle(lifecycle);
            return this;
        }

        public MBuilder withErrorsFrom(DataResult<?> result) {
            this.map.flatMap(v -> result.map(r -> v));
            return this;
        }
    }

    private static class MLike
    implements MapLike<Object> {
        Map<Object, Object> map;

        public MLike(Map<Object, Object> map) {
            this.map = map;
        }

        public Stream<Pair<Object, Object>> entries() {
            return this.map.entrySet().stream().map(t -> Pair.of(t.getKey(), t.getValue()));
        }

        public Object get(Object key) {
            return this.map.get(key);
        }

        public Object get(String key) {
            return this.map.get(key);
        }

        public String toString() {
            return "MLike [" + String.valueOf(this.map) + "]";
        }
    }
}

