/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.util.SerializeUtil;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;

public class ChancedEffect {
    public static final Codec<ChancedEffect> CODEC = RecordCodecBuilder.create(t -> t.group((App)SerializeUtil.fromRFBBStreamCodec(MobEffectInstance.STREAM_CODEC, MobEffectInstance.CODEC).fieldOf("effect").forGetter(o -> o.effect), (App)Codec.FLOAT.fieldOf("chance").forGetter(o -> Float.valueOf(o.chance))).apply((Applicative)t, ChancedEffect::new));
    public MobEffectInstance effect;
    public float chance;

    public ChancedEffect(MobEffectInstance effect, float chance) {
        this.effect = effect;
        this.chance = chance;
    }

    public ChancedEffect(FoodProperties.PossibleEffect eff) {
        this(eff.effect(), eff.probability());
    }

    public Supplier<MobEffectInstance> effectSupplier() {
        return () -> new MobEffectInstance(this.effect);
    }

    public ChancedEffect copy() {
        return new ChancedEffect(new MobEffectInstance(this.effect), this.chance);
    }

    public boolean merge(ChancedEffect other, float otherCount, float thisCount) {
        if (ChancedEffect.isEffectEquals(this.effect, other.effect)) {
            if (this.effect.equals((Object)other.effect) || ((MobEffect)BuiltInRegistries.MOB_EFFECT.get(this.effect.getEffect().getKey())).isInstantenous()) {
                this.chance += other.chance * otherCount / thisCount;
            } else {
                this.effect.duration = (int)(((float)this.effect.duration * this.chance + (float)other.effect.duration * other.chance * otherCount / thisCount) / this.chance);
            }
        }
        return false;
    }

    public void adjustParts(float otherCount, float thisCount) {
        if (((MobEffect)BuiltInRegistries.MOB_EFFECT.get(this.effect.getEffect().getKey())).isInstantenous()) {
            this.chance *= otherCount / thisCount;
        } else {
            this.effect.duration = (int)((float)this.effect.duration * (otherCount / thisCount));
        }
    }

    public static boolean isEffectEquals(MobEffectInstance t1, MobEffectInstance t2) {
        return t1.getEffect() == t2.getEffect() && t1.getAmplifier() == t2.getAmplifier();
    }
}

