/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.network;

import com.teammoeg.caupona.network.CPBaseBlockEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientDataMessage
implements CustomPacketPayload {
    private final short type;
    private final int message;
    private final BlockPos pos;
    public static final CustomPacketPayload.Type<ClientDataMessage> path = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"client_data"));
    public static final StreamCodec<ByteBuf, ClientDataMessage> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClientDataMessage::getPos, (StreamCodec)ByteBufCodecs.SHORT, ClientDataMessage::getType, (StreamCodec)ByteBufCodecs.INT, ClientDataMessage::getMessage, ClientDataMessage::new);

    public ClientDataMessage(BlockPos pos, short type, int message) {
        this.pos = pos;
        this.type = type;
        this.message = message;
    }

    ClientDataMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.type = buffer.readShort();
        this.message = buffer.readInt();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeShort((int)this.type);
        buffer.writeInt(this.message);
    }

    void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockEntity patt0$temp;
            ServerLevel world = (ServerLevel)context.player().level();
            if (world.isLoaded(this.pos) && (patt0$temp = world.getBlockEntity(this.pos)) instanceof CPBaseBlockEntity) {
                CPBaseBlockEntity entity = (CPBaseBlockEntity)patt0$temp;
                entity.handleMessage(this.type, this.message);
            }
        });
    }

    public short getType() {
        return this.type;
    }

    public int getMessage() {
        return this.message;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return path;
    }
}

