/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.network;

import com.teammoeg.caupona.network.ClientDataMessage;
import com.teammoeg.caupona.network.PacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;

public abstract class CPBaseBlockEntity
extends BlockEntity {
    boolean fromNetwork = false;

    public CPBaseBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    public abstract void handleMessage(short var1, int var2);

    public void sendMessage(short type, int data) {
        PacketHandler.sendToServer(new ClientDataMessage(this.worldPosition, type, data));
    }

    public void syncData() {
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public abstract void readCustomNBT(CompoundTag var1, boolean var2, HolderLookup.Provider var3);

    public abstract void writeCustomNBT(CompoundTag var1, boolean var2, HolderLookup.Provider var3);

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        this.fromNetwork = true;
        super.onDataPacket(net, pkt, registries);
    }

    public abstract void tick();

    public Object getCapability(BlockCapability<?, Direction> type, Direction d) {
        return null;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        this.readCustomNBT(nbt, this.fromNetwork, registries);
        super.loadAdditional(nbt, registries);
        this.fromNetwork = false;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        this.writeCustomNBT(compound, false, registries);
        super.saveAdditional(compound, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeCustomNBT(nbt, true, registries);
        return nbt;
    }
}

