/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.item;

import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.item.EdibleBlock;
import com.teammoeg.caupona.util.CreativeTabItemHelper;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class StewItem
extends EdibleBlock {
    Supplier<Fluid> fluid;
    public static final FoodProperties fakefood = new FoodProperties.Builder().nutrition(4).saturationModifier(0.2f).fast().build();

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 16;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Fluid base;
        ResourceLocation rl;
        StewInfo info = (StewInfo)stack.get(CPCapability.STEW_INFO);
        if (info == null) {
            return;
        }
        FloatemStack fs = info.stacks.stream().max((t1, t2) -> t1.getCount() > t2.getCount() ? 1 : (t1.getCount() == t2.getCount() ? 0 : -1)).orElse(null);
        if (fs != null) {
            tooltip.add((Component)Utils.translate("tooltip.caupona.main_ingredient", fs.getStack().getDisplayName()));
        }
        if ((rl = info.spiceName) != null) {
            tooltip.add((Component)Utils.translate("tooltip.caupona.spice", Utils.translate("spice." + rl.getNamespace() + "." + rl.getPath())));
        }
        if ((base = info.base) != null && !info.stacks.isEmpty()) {
            tooltip.add((Component)Utils.translate("tooltip.caupona.base", base.getFluidType().getDescription()));
        }
        PotionContents.addPotionTooltip(info.effects, tooltip::add, (float)1.0f, (float)20.0f);
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void fillItemCategory(CreativeTabItemHelper helper) {
        if (helper.isFoodTab()) {
            ItemStack is = new ItemStack((ItemLike)this);
            is.set(CPCapability.STEW_INFO, (Object)new StewInfo(this.fluid.get()));
            super.addCreativeHints(is);
            helper.accept(is);
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public StewItem(Supplier<Fluid> fluid, Item.Properties properties) {
        super((Block)CPBlocks.BOWL.get(), properties.food(fakefood));
        CPItems.stews.add((Item)this);
        this.fluid = fluid;
    }

    public FoodProperties getFoodProperties(ItemStack stack, LivingEntity entity) {
        StewInfo info = (StewInfo)stack.get(CPCapability.STEW_INFO);
        if (info == null) {
            return null;
        }
        return info.getFood();
    }
}

