/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.item;

import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.blocks.pot.StewPotBlockEntity;
import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.item.CPItem;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.TabType;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class SkimmerItem
extends CPItem {
    public SkimmerItem(Item.Properties properties) {
        super(properties, TabType.MAIN);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        BlockEntity be = context.getLevel().getBlockEntity(pos);
        if (be instanceof StewPotBlockEntity) {
            FluidTank tank;
            FluidStack fluid;
            StewInfo si;
            float dense;
            StewPotBlockEntity stewpot = (StewPotBlockEntity)be;
            if (stewpot.canAddFluid() && (double)(dense = (si = Utils.getOrCreateInfo(fluid = (tank = stewpot.getTank()).getFluidInTank(0))).getDensity()) > 0.5) {
                float toreduce = Math.min(dense - 0.5f, 0.5f);
                float reduced = toreduce * (float)fluid.getAmount() / 250.0f;
                for (FloatemStack lstack : si.stacks) {
                    lstack.shrink(lstack.getCount() / dense * toreduce);
                }
                si.recalculateHAS();
                Utils.setInfo((MutableDataComponentHolder)fluid, si);
                tank.setFluid(fluid);
                stack.hurtAndBreak(1, (LivingEntity)context.getPlayer(), context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                float frac = Mth.frac((float)reduced);
                int amt = Mth.floor((float)reduced);
                if (context.getPlayer().getRandom().nextFloat() < frac) {
                    ++amt;
                }
                ItemHandlerHelper.giveItemToPlayer((Player)context.getPlayer(), (ItemStack)new ItemStack((ItemLike)CPItems.scraps.get(), amt));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

