/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.item;

import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.util.CreativeTabItemHelper;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.ICreativeModeTabItem;
import com.teammoeg.caupona.util.TabType;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class SitulaItem
extends Item
implements ICreativeModeTabItem {
    public SitulaItem(Item.Properties props) {
        super(props);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        FluidStack f;
        @Nullable IFluidHandlerItem e = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (e != null && !(f = e.getFluidInTank(0)).isEmpty()) {
            ResourceLocation rl;
            tooltip.add(f.getHoverName());
            StewInfo info = Utils.getOrCreateInfo(f);
            FloatemStack fs = info.stacks.stream().max((t1, t2) -> t1.getCount() > t2.getCount() ? 1 : (t1.getCount() == t2.getCount() ? 0 : -1)).orElse(null);
            if (fs != null) {
                tooltip.add((Component)Utils.translate("tooltip.caupona.main_ingredient", fs.getStack().getHoverName()));
            }
            if ((rl = info.spiceName) != null) {
                tooltip.add((Component)Utils.translate("tooltip.caupona.spice", Utils.translate("spice." + rl.getNamespace() + "." + rl.getPath())));
            }
            if (info.base != null && !info.stacks.isEmpty()) {
                tooltip.add((Component)Utils.translate("tooltip.caupona.base", info.base.getFluidType().getDescription()));
            }
            PotionContents.addPotionTooltip(info.effects, tooltip::add, (float)1.0f, (float)20.0f);
            tooltip.add((Component)Utils.string(f.getAmount() + "/1250 mB"));
        }
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand pUsedHand) {
        FluidStack fluid;
        IFluidHandlerItem handler;
        BlockHitResult ray = Item.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        ItemStack cur = playerIn.getItemInHand(pUsedHand);
        if (ray.getType() == HitResult.Type.BLOCK) {
            FluidActionResult res;
            BlockPos blockpos = ray.getBlockPos();
            FluidState state = worldIn.getFluidState(blockpos);
            BlockState blk = worldIn.getBlockState(blockpos);
            Block block = blk.getBlock();
            if (block instanceof BucketPickup) {
                int amt;
                FluidStack fluid2;
                BucketPickup bucket = (BucketPickup)block;
                IFluidHandlerItem handler2 = (IFluidHandlerItem)cur.getCapability(Capabilities.FluidHandler.ITEM);
                if (handler2 != null && !(fluid2 = handler2.getFluidInTank(0)).isEmpty() && fluid2.getAmount() < handler2.getTankCapacity(0) && fluid2.getFluid().isSame(state.getType()) && (amt = handler2.fill(new FluidStack(state.getType(), 1000), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    bucket.pickupBlock(playerIn, (LevelAccessor)worldIn, blockpos, blk);
                    return InteractionResultHolder.sidedSuccess((Object)cur, (boolean)worldIn.isClientSide);
                }
            }
            if ((res = FluidUtil.tryPickUpFluid((ItemStack)cur, (Player)playerIn, (Level)worldIn, (BlockPos)blockpos, (Direction)ray.getDirection())).isSuccess()) {
                return InteractionResultHolder.sidedSuccess((Object)res.getResult(), (boolean)worldIn.isClientSide);
            }
        } else if (ray.getType() == HitResult.Type.MISS && playerIn.isShiftKeyDown() && (handler = (IFluidHandlerItem)cur.getCapability(Capabilities.FluidHandler.ITEM)) != null && !(fluid = handler.getFluidInTank(0)).isEmpty() && handler.drain(1250, IFluidHandler.FluidAction.EXECUTE).getAmount() > 0) {
            return InteractionResultHolder.sidedSuccess((Object)cur, (boolean)worldIn.isClientSide);
        }
        return InteractionResultHolder.pass((Object)cur);
    }

    @Override
    public void fillItemCategory(CreativeTabItemHelper helper) {
        if (helper.isType(TabType.MAIN)) {
            helper.accept((ItemLike)this);
        }
    }
}

