/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.item;

import com.teammoeg.caupona.container.PortableBrazierContainer;
import com.teammoeg.caupona.item.CPItem;
import com.teammoeg.caupona.util.TabType;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PortableBrazierItem
extends CPItem
implements MenuProvider {
    public PortableBrazierItem(Item.Properties properties) {
        super(properties, TabType.MAIN);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        InteractionResultHolder ret = super.use(pLevel, pPlayer, pUsedHand);
        if (ret.getResult().consumesAction()) {
            return ret;
        }
        if (!pPlayer.isShiftKeyDown()) {
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)pPlayer;
                player.openMenu((MenuProvider)this);
            }
            return InteractionResultHolder.sidedSuccess((Object)pPlayer.getItemInHand(pUsedHand), (boolean)pLevel.isClientSide);
        }
        return ret;
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new PortableBrazierContainer(pContainerId, pInventory);
    }

    public Component getDisplayName() {
        return Utils.translate("container.caupona.portable_brazier.title");
    }
}

