/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.item;

import com.teammoeg.caupona.item.CPBlockItem;
import com.teammoeg.caupona.util.CreativeTabItemHelper;
import com.teammoeg.caupona.util.TabType;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class EdibleBlock
extends CPBlockItem {
    public EdibleBlock(Block block, Item.Properties props) {
        super(block, props, TabType.FOODS);
    }

    @Override
    public void fillItemCategory(CreativeTabItemHelper helper) {
        if (helper.isFoodTab()) {
            ItemStack is = new ItemStack((ItemLike)this);
            this.addCreativeHints(is);
            helper.accept(is);
        }
    }

    public void addCreativeHints(ItemStack stack) {
        ItemLore lc = (ItemLore)stack.get(DataComponents.LORE);
        lc = lc.withLineAdded((Component)Utils.translate("tooltip.caupona.display_only")).withLineAdded((Component)Utils.translate("tooltip.caupona.cook_required"));
        stack.set(DataComponents.LORE, (Object)lc);
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level worldIn, LivingEntity entityLiving) {
        super.finishUsingItem(itemstack, worldIn, entityLiving);
        return new ItemStack((ItemLike)Items.BOWL);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        InteractionResult interactionresult = InteractionResult.PASS;
        if (pContext.getPlayer().isShiftKeyDown()) {
            interactionresult = this.place(new BlockPlaceContext(pContext));
        }
        if (!interactionresult.consumesAction()) {
            InteractionResult interactionresult1 = this.use(pContext.getLevel(), pContext.getPlayer(), pContext.getHand()).getResult();
            return interactionresult1 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionresult1;
        }
        return interactionresult;
    }
}

