/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.item;

import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.blocks.foods.DishBlock;
import com.teammoeg.caupona.components.IFoodInfo;
import com.teammoeg.caupona.components.SauteedFoodInfo;
import com.teammoeg.caupona.item.EdibleBlock;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;

public class DishItem
extends EdibleBlock {
    public static final FoodProperties fakefood = new FoodProperties.Builder().nutrition(4).saturationModifier(0.2f).usingConvertsTo((ItemLike)Items.BOWL).build();
    public final DishBlock bl;

    public DishItem(DishBlock block, Item.Properties props) {
        super(block, props.food(fakefood));
        CPItems.dish.add((Item)this);
        this.bl = block;
    }

    public int getUseDuration(ItemStack stack, LivingEntity ent) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IFoodInfo iinfo = (IFoodInfo)CPCapability.FOOD_INFO.getCapability(stack, null);
        if (iinfo instanceof SauteedFoodInfo) {
            ResourceLocation rl;
            SauteedFoodInfo info = (SauteedFoodInfo)iinfo;
            FloatemStack fs = info.stacks.stream().max((t1, t2) -> t1.getCount() > t2.getCount() ? 1 : (t1.getCount() == t2.getCount() ? 0 : -1)).orElse(null);
            if (fs != null) {
                tooltip.add((Component)Utils.translate("tooltip.caupona.main_ingredient", fs.getStack().getDisplayName()));
            }
            if ((rl = info.spiceName) != null) {
                tooltip.add((Component)Utils.translate("tooltip.caupona.spice", Utils.translate("spice." + rl.getNamespace() + "." + rl.getPath())));
            }
        }
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    public FoodProperties getFoodProperties(ItemStack stack, LivingEntity entity) {
        return ((IFoodInfo)CPCapability.FOOD_INFO.getCapability(stack, null)).getFood();
    }
}

