/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.item;

import com.teammoeg.caupona.entity.CPBoat;
import com.teammoeg.caupona.item.CPItem;
import com.teammoeg.caupona.util.TabType;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CPBoatItem
extends CPItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final String type;

    public CPBoatItem(String pType, Item.Properties pProperties) {
        super(pProperties, TabType.MAIN_AND_TRANSPORTATION);
        this.type = pType;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        BlockHitResult hitresult = CPBoatItem.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vec3 = pPlayer.getViewVector(1.0f);
        List list = pLevel.getEntities((Entity)pPlayer, pPlayer.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = pPlayer.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            CPBoat boat = new CPBoat(pLevel, hitresult.getLocation().x, hitresult.getLocation().y, hitresult.getLocation().z);
            boat.setWoodType(this.type);
            boat.setYRot(pPlayer.getYRot());
            if (!pLevel.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!pLevel.isClientSide) {
                pLevel.addFreshEntity((Entity)boat);
                Vec3 hitpos = hitresult.getLocation();
                pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.ENTITY_PLACE, new BlockPos((int)hitpos.x(), (int)hitpos.y(), (int)hitpos.z()));
                if (!pPlayer.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

