/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.entity;

import com.teammoeg.caupona.CPEntityTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class CPBoat
extends Boat {
    private static final EntityDataAccessor<String> WOOD_TYPE = SynchedEntityData.defineId(CPBoat.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public CPBoat(EntityType<? extends Boat> p_38290_, Level p_38291_) {
        super(p_38290_, p_38291_);
    }

    public CPBoat(Level p_38293_, double p_38294_, double p_38295_, double p_38296_) {
        this((EntityType<? extends Boat>)((EntityType)CPEntityTypes.BOAT.get()), p_38293_);
        this.setPos(p_38294_, p_38295_, p_38296_);
        this.xo = p_38294_;
        this.yo = p_38295_;
        this.zo = p_38296_;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WOOD_TYPE, (Object)"walnut");
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setWoodType(compound.getString("CPType"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("CPType", this.getWoodType());
    }

    public String getWoodType() {
        return (String)this.entityData.get(WOOD_TYPE);
    }

    public void setWoodType(String wood) {
        this.entityData.set(WOOD_TYPE, (Object)wood);
    }

    public Item getDropItem() {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)(this.getWoodType() + "_boat")));
    }
}

