/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.datagen;

import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.StewBaseCondition;
import com.teammoeg.caupona.data.recipes.StewCookingRecipe;
import com.teammoeg.caupona.data.recipes.baseconditions.FluidTag;
import com.teammoeg.caupona.data.recipes.baseconditions.FluidType;
import com.teammoeg.caupona.data.recipes.baseconditions.FluidTypeType;
import com.teammoeg.caupona.datagen.IngredientConditionsBuilder;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class StewRecipeBuilder {
    private List<IngredientCondition> allow = new ArrayList<IngredientCondition>();
    private List<IngredientCondition> deny = new ArrayList<IngredientCondition>();
    private int priority = 0;
    private int time = 200;
    private float density = 0.75f;
    private List<StewBaseCondition> base = new ArrayList<StewBaseCondition>();
    private Fluid output;
    private ResourceLocation id;
    private boolean removeNBT = false;

    public StewRecipeBuilder(ResourceLocation id, Fluid out) {
        this.output = out;
        this.id = id;
    }

    public static StewRecipeBuilder start(Fluid out) {
        return new StewRecipeBuilder(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)("cooking/" + Utils.getRegistryName(out).getPath())), out);
    }

    public IngredientConditionsBuilder<StewRecipeBuilder> require() {
        return new IngredientConditionsBuilder<StewRecipeBuilder>(this, this.allow, this.allow, this.deny);
    }

    public IngredientConditionsBuilder<StewRecipeBuilder> not() {
        return new IngredientConditionsBuilder<StewRecipeBuilder>(this, this.deny, this.allow, this.deny);
    }

    public StewBaseBuilder base() {
        return new StewBaseBuilder(this);
    }

    public StewRecipeBuilder prio(int p) {
        this.priority = p;
        return this;
    }

    public StewRecipeBuilder special() {
        this.priority |= 0x400;
        return this;
    }

    public StewRecipeBuilder high() {
        this.priority |= 0x80;
        return this;
    }

    public StewRecipeBuilder med() {
        this.priority |= 0x40;
        return this;
    }

    public StewRecipeBuilder low() {
        return this;
    }

    public StewRecipeBuilder time(int t) {
        this.time = t;
        return this;
    }

    public StewRecipeBuilder dense(double d) {
        this.density = (float)d;
        return this;
    }

    public StewRecipeBuilder removeNBT() {
        this.removeNBT = true;
        return this;
    }

    public StewCookingRecipe end() {
        return new StewCookingRecipe(this.allow, this.deny, this.priority, this.time, this.density, this.base, this.output, this.removeNBT);
    }

    public StewCookingRecipe finish(BiConsumer<ResourceLocation, IDataRecipe> out) {
        StewCookingRecipe r = this.end();
        out.accept(this.id, r);
        return r;
    }

    public static class StewBaseBuilder {
        private StewRecipeBuilder parent;

        public StewBaseBuilder(StewRecipeBuilder parent) {
            this.parent = parent;
        }

        public StewBaseBuilder tag(ResourceLocation rl) {
            this.parent.base.add(new FluidTag(rl));
            return this;
        }

        public StewBaseBuilder tag(TagKey<Fluid> rl) {
            this.parent.base.add(new FluidTag(rl.location()));
            return this;
        }

        public StewBaseBuilder type(Fluid f) {
            this.parent.base.add(new FluidType(f));
            return this;
        }

        public StewBaseBuilder only(Fluid f) {
            this.parent.base.add(new FluidTypeType(f));
            return this;
        }

        public StewRecipeBuilder and() {
            return this.parent;
        }
    }
}

