/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.datagen;

import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.SauteedRecipe;
import com.teammoeg.caupona.datagen.IngredientConditionsBuilder;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class SauteedRecipeBuilder {
    private List<IngredientCondition> allow = new ArrayList<IngredientCondition>();
    private List<IngredientCondition> deny = new ArrayList<IngredientCondition>();
    private int priority = 0;
    private int time = 200;
    private Item output;
    private ResourceLocation id;
    private boolean removeNBT = false;
    private float per = 2.0f;

    public SauteedRecipeBuilder(ResourceLocation id, Item out) {
        this.output = out;
        this.id = id;
    }

    public static SauteedRecipeBuilder start(Item out) {
        return new SauteedRecipeBuilder(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)("frying/" + Utils.getRegistryName(out).getPath())), out);
    }

    public IngredientConditionsBuilder<SauteedRecipeBuilder> require() {
        return new IngredientConditionsBuilder<SauteedRecipeBuilder>(this, this.allow, this.allow, this.deny);
    }

    public IngredientConditionsBuilder<SauteedRecipeBuilder> not() {
        return new IngredientConditionsBuilder<SauteedRecipeBuilder>(this, this.deny, this.allow, this.deny);
    }

    public SauteedRecipeBuilder prio(int p) {
        this.priority = p;
        return this;
    }

    public SauteedRecipeBuilder special() {
        this.priority |= 0x400;
        return this;
    }

    public SauteedRecipeBuilder high() {
        this.priority |= 0x80;
        return this;
    }

    public SauteedRecipeBuilder med() {
        this.priority |= 0x40;
        return this;
    }

    public SauteedRecipeBuilder low() {
        return this;
    }

    public SauteedRecipeBuilder time(int t) {
        this.time = t;
        return this;
    }

    public SauteedRecipeBuilder removeNBT() {
        this.removeNBT = true;
        return this;
    }

    public SauteedRecipeBuilder perBowl(float num) {
        this.per = num;
        return this;
    }

    public SauteedRecipe end() {
        return new SauteedRecipe(this.allow, this.deny, this.priority, this.time, this.output, this.removeNBT, this.per);
    }

    public SauteedRecipe finish(BiConsumer<ResourceLocation, IDataRecipe> out) {
        SauteedRecipe r = this.end();
        out.accept(this.id, r);
        return r;
    }
}

