/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.datagen;

import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.numbers.Add;
import com.teammoeg.caupona.data.recipes.numbers.ConstNumber;
import com.teammoeg.caupona.data.recipes.numbers.ItemIngredient;
import com.teammoeg.caupona.data.recipes.numbers.ItemTag;
import com.teammoeg.caupona.data.recipes.numbers.ItemType;
import com.teammoeg.caupona.data.recipes.numbers.NopNumber;
import com.teammoeg.caupona.datagen.IngredientConditionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientNumberBuilder<T> {
    private IngredientConditionsBuilder<T> parent;
    private List<CookIngredients> types = new ArrayList<CookIngredients>();
    private Consumer<CookIngredients> fin;

    public IngredientNumberBuilder(IngredientConditionsBuilder<T> parent, Consumer<CookIngredients> fin) {
        this.parent = parent;
        this.fin = fin;
    }

    public IngredientNumberBuilder<T> of(float n) {
        return this.of(new ConstNumber(n));
    }

    public IngredientNumberBuilder<T> of(Ingredient i) {
        return this.of(new ItemIngredient(i));
    }

    public IngredientNumberBuilder<T> of(Ingredient i, String desc) {
        return this.of(new ItemIngredient(i, desc));
    }

    public IngredientNumberBuilder<T> of(ResourceLocation i) {
        return this.of(new ItemTag(i));
    }

    public IngredientNumberBuilder<T> of(TagKey<Item> i) {
        return this.of(i.location());
    }

    public IngredientNumberBuilder<T> of(Item i) {
        return this.of(new ItemType(i));
    }

    public IngredientNumberBuilder<T> of(CookIngredients sn) {
        this.types.add(sn);
        return this;
    }

    public IngredientNumberBuilder<T> plus(CookIngredients sn) {
        if (this.types.size() <= 0) {
            return this.of(sn);
        }
        CookIngredients sn2 = this.types.get(this.types.size() - 1);
        if (sn2 instanceof Add) {
            Add add = (Add)sn2;
            add.add(sn);
        } else {
            ArrayList<CookIngredients> t2s = new ArrayList<CookIngredients>();
            t2s.add(sn2);
            t2s.add(sn);
            this.types.set(this.types.size() - 1, new Add(t2s));
        }
        return this;
    }

    public IngredientNumberBuilder<T> plus(float n) {
        return this.plus(new ConstNumber(n));
    }

    public IngredientNumberBuilder<T> plus(Ingredient i) {
        return this.plus(new ItemIngredient(i));
    }

    public IngredientNumberBuilder<T> plus(ResourceLocation i) {
        return this.plus(new ItemTag(i));
    }

    public IngredientNumberBuilder<T> plus(TagKey<Item> i) {
        return this.plus(i.location());
    }

    public IngredientNumberBuilder<T> plus(Item i) {
        return this.plus(new ItemType(i));
    }

    public IngredientNumberBuilder<T> nop() {
        return this.of(NopNumber.INSTANCE);
    }

    public IngredientConditionsBuilder<T> and() {
        if (!this.types.isEmpty()) {
            this.types.forEach(this.fin);
        }
        return this.parent;
    }
}

