/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.datagen;

import com.google.common.hash.Hashing;
import com.teammoeg.caupona.datagen.JavaFileOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class FileGenerator
implements DataProvider {
    protected final PackOutput output;
    protected ExistingFileHelper helper;
    private String name;
    PackType type;

    public FileGenerator(PackType pt, PackOutput output, ExistingFileHelper helper, String name) {
        this.type = pt;
        this.output = output;
        this.helper = helper;
        this.name = name;
    }

    protected abstract void gather(FileStorage var1);

    public CompletableFuture<?> run(CachedOutput pOutput) {
        ArrayList work = new ArrayList();
        this.gather(new FileStorage(pOutput));
        return CompletableFuture.allOf((CompletableFuture[])work.toArray(CompletableFuture[]::new));
    }

    protected Path getDatagenOutput() {
        return this.output.getOutputFolder();
    }

    protected Path getJavaOutput() {
        return this.output.getOutputFolder().getParent().getParent().resolve("main/java");
    }

    protected Path getClassPath(String classPath) {
        return this.getJavaOutput().resolve(String.join((CharSequence)"/", classPath.split("\\.")) + ".java");
    }

    protected String getGeneratedPackage() {
        return "com.teammoeg.caupona.generated";
    }

    protected Path getGeneratedClassPath(String className) {
        return this.getClassPath(this.getGeneratedPackage() + "." + className);
    }

    public FileOutput createOutput(Path t) {
        return new FileOutput(t);
    }

    public JavaFileOutput createJavaOutput(String classPath) {
        return new JavaFileOutput(this, classPath);
    }

    public JavaFileOutput createGeneratedJavaOutput(String classPath) {
        return new JavaFileOutput(this, this.getGeneratedPackage() + "." + classPath);
    }

    public String getName() {
        return this.name + " File Generator";
    }

    static CompletableFuture<?> saveFile(CachedOutput cache, byte[] data, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                cache.writeIfNeeded(path, data, Hashing.sha1().hashBytes(data));
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to save file to {}", (Object)path, (Object)ioexception);
            }
        }, Util.backgroundExecutor());
    }

    protected class FileStorage
    implements BiConsumer<Path, byte[]>,
    Consumer<FileOutput> {
        CachedOutput out;

        public FileStorage(CachedOutput out) {
            this.out = out;
        }

        @Override
        public void accept(ResourceLocation rl, byte[] s) {
            Path p = FileGenerator.this.output.getOutputFolder().resolve(FileGenerator.this.type.getDirectory() + "/" + rl.getNamespace() + "/" + rl.getPath());
            this.accept(p, s);
        }

        @Override
        public void accept(Path t, byte[] u) {
            FileGenerator.saveFile(this.out, u, t);
        }

        @Override
        public void accept(Path t, String s) {
            this.accept(t, s.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public void accept(ResourceLocation rl, String s) {
            this.accept(rl, s.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public void accept(FileOutput t) {
            this.accept(t.out, t.stream.toByteArray());
        }
    }

    public static class FileOutput {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream ps;
        Path out;

        private FileOutput(Path out) {
            this.out = out;
        }

        public OutputStream getOutput() {
            return this.stream;
        }

        public PrintStream getPrint() {
            if (this.ps != null) {
                return this.ps;
            }
            this.ps = new PrintStream((OutputStream)this.stream, true, StandardCharsets.UTF_8);
            return this.ps;
        }
    }
}

