/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemType
implements CookIngredients {
    Item type;
    public static final MapCodec<ItemType> CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(o -> o.type)).apply((Applicative)t, ItemType::new));

    public ItemType(Item type) {
        this.type = type;
    }

    @Override
    public Float apply(IPendingContext t) {
        if (this.type == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(t.getOfItem(i -> i.getItem().equals(this.type)));
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return stack.getItem().equals(this.type);
    }

    @Override
    public Stream<CookIngredients> getItemRelated() {
        return Stream.of(this);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemType other = (ItemType)obj;
        return Objects.equals(this.type, other.type);
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.empty();
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation(this.type.getDescriptionId(), new Object[0]);
    }

    @Override
    public Stream<ItemStack> getStacks() {
        return Stream.of(new ItemStack((ItemLike)this.type));
    }
}

