/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemTag
implements CookIngredients {
    public static final MapCodec<ItemTag> CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)ResourceLocation.CODEC.fieldOf("tag").forGetter(o -> o.tag)).apply((Applicative)t, ItemTag::new));
    ResourceLocation tag;

    public ItemTag(ResourceLocation tag) {
        this.tag = tag;
    }

    @Override
    public Float apply(IPendingContext t) {
        return Float.valueOf(t.getOfType(this.tag));
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return stack.getTags().contains(this.tag);
    }

    @Override
    public Stream<CookIngredients> getItemRelated() {
        return Stream.of(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemTag)) {
            return false;
        }
        ItemTag other = (ItemTag)obj;
        return !(this.tag == null ? other.tag != null : !this.tag.equals((Object)other.tag));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.of(this.tag);
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslationOrElse("tag." + this.tag.toLanguageKey().replaceAll("/", "."), "#" + this.tag.toString(), new Object[0]);
    }

    @Override
    public Stream<ItemStack> getStacks() {
        return BuiltInRegistries.ITEM.getTag(ItemTags.create((ResourceLocation)this.tag)).stream().flatMap(t -> t.stream()).map(t -> new ItemStack((ItemLike)t.value()));
    }
}

