/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemIngredient
implements CookIngredients {
    public static final MapCodec<ItemIngredient> CODEC = RecordCodecBuilder.mapCodec(t -> t.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(o -> o.i), (App)Codec.STRING.optionalFieldOf("translation").forGetter(o -> Optional.ofNullable(o.translation))).apply((Applicative)t, ItemIngredient::new));
    Ingredient i;
    String translation = "";

    public ItemIngredient(Ingredient i) {
        this.i = i;
    }

    public ItemIngredient(Ingredient i, Optional<String> translation) {
        this.i = i;
        this.translation = translation.orElse(null);
    }

    public ItemIngredient(Ingredient i, String translation) {
        this.i = i;
        this.translation = translation;
    }

    @Override
    public Float apply(IPendingContext t) {
        return Float.valueOf(t.getOfItem((Predicate<ItemStack>)this.i));
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return this.i.test(stack.getStack());
    }

    @Override
    public Stream<CookIngredients> getItemRelated() {
        return Stream.of(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.i == null ? 0 : this.i.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemIngredient)) {
            return false;
        }
        ItemIngredient other = (ItemIngredient)obj;
        return !(this.i == null ? other.i != null : !this.i.equals((Object)other.i));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.empty();
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslationOrElse(this.translation, this.translation, new Object[0]);
    }

    @Override
    public Stream<ItemStack> getStacks() {
        return Arrays.stream(this.i.getItems());
    }
}

